/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.view.View;
import android.widget.TextView;

import com.liveperson.infra.ui.R;

/**
 * ViewHolder class for messages from consumer.
 * <p>
 * Created by ofira on 11/01/2016.
 */
public abstract class EndViewHolder extends BaseMessageViewHolder {

    protected TextView mTimestampTextView;

    public EndViewHolder(View itemView) {
        super(itemView);
        mTimestampTextView = (TextView)itemView.findViewById(R.id.lpui_message_timestamp);
    }

    @Override
    public void updateContentDescription() {

    }

    public void setTimestampTextView(long timestamp){
		super.setTimestampTextView(timestamp);

        String timestampText = getTimeFormat(timestamp);
        mTimestampTextView.setText(timestampText);
    }

}
