/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.ui.view.resources;

import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.res.ResourcesCompat;
import com.liveperson.infra.configuration.Configuration;

public class ResourceHelper {
    public static void updateTextColor(TextView textView, @ColorRes int colorResId) {
        if (textView == null) {
            return;
        }
        textView.setTextColor(Configuration.getColor((int)colorResId));
    }

    public static void updateTextColorLink(TextView textView, @ColorRes int colorResId) {
        if (textView == null) {
            return;
        }
        textView.setLinkTextColor(Configuration.getColor((int)colorResId));
    }

    public static void updateBackgroundStrokeColor(View view, @ColorRes int colorResId, @DimenRes int strokeWidthDimensionId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable2 = (GradientDrawable)background;
            drawable2.setStroke((int)Configuration.getDimension((int)strokeWidthDimensionId), Configuration.getColor((int)colorResId));
        }
    }

    public static void updateBackgroundDrawable(View view, @DrawableRes int drawableResId) {
        if (view == null) {
            return;
        }
        Drawable bg = ResourcesCompat.getDrawable((Resources)view.getResources(), (int)drawableResId, null);
        view.setBackground(bg);
    }

    public static void updateBackgroundSolidColor(View view, @ColorRes int colorResId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof GradientDrawable) {
            GradientDrawable drawable2 = (GradientDrawable)background;
            drawable2.setColor(Configuration.getColor((int)colorResId));
        }
    }

    public static void updateBackgroundColor(View view, int colorResId) {
        if (view == null) {
            return;
        }
        Drawable background = view.getBackground();
        if (background instanceof ColorDrawable) {
            ((ColorDrawable)background).setColor(Configuration.getColor((int)colorResId));
        }
    }
}

