/* Copyright (c) LivePerson, Inc. */
package com.liveperson.infra.ui.view.adapter.viewholder;

import android.text.format.DateUtils;
import android.view.View;
import android.widget.TextView;

import com.liveperson.infra.ui.R;

import java.text.DateFormat;

/**
 * Created by ofira on 21/01/2016.
 */
public class HeaderViewHolder extends BaseViewHolder {

	private TextView mHeaderTextView;

	public HeaderViewHolder(View itemView) {
		super(itemView);
		mHeaderTextView = itemView.findViewById(R.id.lpui_message_text);
	}

	@Override
	public String getTextToCopy() {
		//not able to copy header
		return null;
	}

	@Override
	public void updateContentDescription() {
	}

	public void setHeaderText(long timeStamp) {
		String headerText;
		if (DateUtils.isToday(timeStamp)) {
			headerText = mHeaderTextView.getResources().getString(R.string.lp_today);
		} else if (com.liveperson.infra.utils.DateUtils.isYesterday(timeStamp)) {
			headerText = mHeaderTextView.getResources().getString(R.string.lp_yesterday);
		} else {
			String customDateFormat = mHeaderTextView.getResources().getString(R.string.lp_date_format);
			headerText = com.liveperson.infra.utils.DateUtils.getFormattedDate(customDateFormat, DateFormat.SHORT, timeStamp);
		}
		mHeaderTextView.setText(headerText);
	}
}
