/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty9.websockets;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import java.util.Optional;
import javax.websocket.OnError;
import javax.websocket.OnMessage;

public class EventDriverMetrics {
    public final Optional<Meter> onTextMeter;
    public final Optional<Counter> countOpened;
    public final Optional<Timer> timer;
    public final Optional<Meter> exceptionMetered;
    public static final String OPEN_CONNECTIONS = "openConnections";

    public EventDriverMetrics(Class<?> endpointClass, MetricRegistry metrics) {
        Class<?> klass = endpointClass;
        Metered metered = klass.getAnnotation(Metered.class);
        Timed timed = klass.getAnnotation(Timed.class);
        ExceptionMetered em = klass.getAnnotation(ExceptionMetered.class);
        this.onTextMeter = metered != null ? Optional.of(metrics.meter(MetricRegistry.name((String)metered.name(), (String[])new String[]{klass.getName(), OnMessage.class.getSimpleName()}))) : Optional.empty();
        this.countOpened = metered != null ? Optional.of(metrics.counter(MetricRegistry.name((String)metered.name(), (String[])new String[]{klass.getName(), OPEN_CONNECTIONS}))) : Optional.empty();
        this.timer = timed != null ? Optional.of(metrics.timer(MetricRegistry.name((String)timed.name(), (String[])new String[]{klass.getName()}))) : Optional.empty();
        this.exceptionMetered = em != null ? Optional.of(metrics.meter(MetricRegistry.name((String)em.name(), (String[])new String[]{klass.getName(), OnError.class.getSimpleName()}))) : Optional.empty();
    }
}

