/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty9.websockets;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.metrics.jetty9.websockets.annotated.InstJsrServerEndpointImpl;
import io.dropwizard.metrics.jetty9.websockets.endpoint.InstJsrServerExtendsEndpointImpl;
import java.util.concurrent.Executor;
import javax.servlet.ServletException;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.server.NativeWebSocketConfiguration;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;

public class InstWebSocketServerContainerInitializer {
    public static ServerContainer configureContext(MutableServletContextHandler context, MetricRegistry metrics) throws ServletException {
        WebSocketUpgradeFilter filter = WebSocketUpgradeFilter.configureContext((ServletContextHandler)context);
        NativeWebSocketConfiguration wsConfig = filter.getConfiguration();
        ServerContainer wsContainer = new ServerContainer(wsConfig, (Executor)context.getServer().getThreadPool());
        EventDriverFactory edf = wsConfig.getFactory().getEventDriverFactory();
        edf.clearImplementations();
        edf.addImplementation((EventDriverImpl)new InstJsrServerEndpointImpl(metrics));
        edf.addImplementation((EventDriverImpl)new InstJsrServerExtendsEndpointImpl(metrics));
        context.addBean((Object)wsContainer);
        context.setAttribute(javax.websocket.server.ServerContainer.class.getName(), (Object)wsContainer);
        context.setAttribute(WebSocketUpgradeFilter.class.getName(), (Object)filter);
        return wsContainer;
    }
}

