/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty9.websockets.annotated;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.dropwizard.metrics.jetty9.websockets.EventDriverMetrics;
import javax.websocket.CloseReason;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrEvents;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrAnnotatedEventDriver;

public class InstJsrAnnotatedEventDriver
extends JsrAnnotatedEventDriver {
    private final EventDriverMetrics edm;

    public InstJsrAnnotatedEventDriver(WebSocketPolicy policy, EndpointInstance ei, JsrEvents<ServerEndpoint, ServerEndpointConfig> events, MetricRegistry metrics) {
        super(policy, ei, events);
        this.edm = new EventDriverMetrics(this.metadata.getEndpointClass(), metrics);
    }

    public void onTextMessage(String message) {
        this.edm.onTextMeter.ifPresent(Meter::mark);
        super.onTextMessage(message);
    }

    public void onConnect() {
        this.edm.countOpened.ifPresent(Counter::inc);
        this.edm.timer.ifPresent(e -> this.getJsrSession().getUserProperties().put(((Object)((Object)this)).getClass().getName(), e.time()));
        super.onConnect();
    }

    public void onError(Throwable cause) {
        this.edm.exceptionMetered.ifPresent(Meter::mark);
        super.onError(cause);
    }

    protected void onClose(CloseReason closereason) {
        this.edm.countOpened.ifPresent(Counter::dec);
        Timer.Context ctx = (Timer.Context)this.getJsrSession().getUserProperties().get(((Object)((Object)this)).getClass().getName());
        if (ctx != null) {
            ctx.close();
        }
        super.onClose(closereason);
    }
}

