/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty9.websockets.annotated;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.metrics.jetty9.websockets.annotated.InstJsrAnnotatedEventDriver;
import io.dropwizard.websockets.GeneralUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import org.eclipse.jetty.websocket.jsr356.annotations.AnnotatedEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.annotations.JsrEvents;
import org.eclipse.jetty.websocket.jsr356.annotations.OnMessageCallable;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.server.AnnotatedServerEndpointMetadata;
import org.eclipse.jetty.websocket.jsr356.server.JsrServerEndpointImpl;
import org.eclipse.jetty.websocket.jsr356.server.PathParamServerEndpointConfig;

public class InstJsrServerEndpointImpl
implements EventDriverImpl {
    private final MetricRegistry metrics;
    private final JsrServerEndpointImpl origImpl;
    private final Method getMaxMessageSizeMethod;

    public InstJsrServerEndpointImpl(MetricRegistry metrics) {
        this.metrics = metrics;
        this.origImpl = new JsrServerEndpointImpl();
        this.getMaxMessageSizeMethod = GeneralUtils.rethrow(() -> this.origImpl.getClass().getDeclaredMethod("getMaxMessageSize", Integer.TYPE, OnMessageCallable[].class)).get();
        this.getMaxMessageSizeMethod.setAccessible(true);
    }

    public EventDriver create(Object websocket, WebSocketPolicy policy) throws Throwable {
        if (!(websocket instanceof EndpointInstance)) {
            throw new IllegalStateException(String.format("Websocket %s must be an %s", websocket.getClass().getName(), EndpointInstance.class.getName()));
        }
        EndpointInstance ei = (EndpointInstance)websocket;
        AnnotatedServerEndpointMetadata metadata = (AnnotatedServerEndpointMetadata)ei.getMetadata();
        JsrEvents events = new JsrEvents((AnnotatedEndpointMetadata)metadata);
        int maxBinaryMessage = this.getMaxMessageSize(policy.getMaxBinaryMessageSize(), new OnMessageCallable[]{metadata.onBinary, metadata.onBinaryStream});
        int maxTextMessage = this.getMaxMessageSize(policy.getMaxTextMessageSize(), new OnMessageCallable[]{metadata.onText, metadata.onTextStream});
        policy.setMaxBinaryMessageSize(maxBinaryMessage);
        policy.setMaxTextMessageSize(maxTextMessage);
        InstJsrAnnotatedEventDriver driver = new InstJsrAnnotatedEventDriver(policy, ei, (JsrEvents<ServerEndpoint, ServerEndpointConfig>)events, this.metrics);
        ServerEndpointConfig config = (ServerEndpointConfig)ei.getConfig();
        if (config instanceof PathParamServerEndpointConfig) {
            PathParamServerEndpointConfig ppconfig = (PathParamServerEndpointConfig)config;
            driver.setPathParameters(ppconfig.getPathParamMap());
        }
        return driver;
    }

    public String describeRule() {
        return this.origImpl.describeRule();
    }

    private int getMaxMessageSize(int defaultMaxMessageSize, OnMessageCallable ... onMessages) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)this.getMaxMessageSizeMethod.invoke((Object)this.origImpl, defaultMaxMessageSize, onMessages);
    }

    public boolean supports(Object websocket) {
        return this.origImpl.supports(websocket);
    }
}

