/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.metrics.jetty9.websockets.endpoint;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.dropwizard.metrics.jetty9.websockets.EventDriverMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.websocket.CloseReason;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.endpoints.JsrEndpointEventDriver;

public class InstJsrEndpointEventDriver
extends JsrEndpointEventDriver {
    private final EventDriverMetrics edm;

    public InstJsrEndpointEventDriver(WebSocketPolicy policy, EndpointInstance ei, MetricRegistry metrics) {
        super(policy, ei);
        this.edm = new EventDriverMetrics(this.metadata.getEndpointClass(), metrics);
    }

    public void onTextFrame(ByteBuffer buffer, boolean fin) throws IOException {
        super.onTextFrame(buffer, fin);
        if (this.activeMessage == null) {
            this.edm.onTextMeter.ifPresent(Meter::mark);
        }
    }

    public void onError(Throwable cause) {
        this.edm.exceptionMetered.ifPresent(Meter::mark);
        super.onError(cause);
    }

    public void onConnect() {
        this.edm.countOpened.ifPresent(Counter::inc);
        this.edm.timer.ifPresent(e -> this.getJsrSession().getUserProperties().put(((Object)((Object)this)).getClass().getName(), e.time()));
        super.onConnect();
    }

    protected void onClose(CloseReason closereason) {
        this.edm.countOpened.ifPresent(Counter::dec);
        Timer.Context ctx = (Timer.Context)this.getJsrSession().getUserProperties().get(((Object)((Object)this)).getClass().getName());
        if (ctx != null) {
            ctx.close();
        }
        super.onClose(closereason);
    }
}

