/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.websockets;

import java.util.function.Consumer;
import java.util.function.Supplier;

public class GeneralUtils {
    public static <T> Consumer<T> rethrow(ConsumerCheckException<T> c) {
        return t -> {
            try {
                c.accept(t);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static <T> Supplier<T> rethrow(SupplierCheckException<T> c) {
        return () -> {
            try {
                return c.get();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    public static Runnable rethrow(RunnableCheckException r) {
        return () -> {
            try {
                r.run();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        };
    }

    @FunctionalInterface
    public static interface SupplierCheckException<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface RunnableCheckException {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ConsumerCheckException<T> {
        public void accept(T var1) throws Exception;
    }
}

