/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.websockets;

import io.dropwizard.Bundle;
import io.dropwizard.metrics.jetty9.websockets.InstWebSocketServerContainerInitializer;
import io.dropwizard.setup.Bootstrap;
import io.dropwizard.setup.Environment;
import io.dropwizard.websockets.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketBundle
implements Bundle {
    private final Collection<ServerEndpointConfig> endpointConfigs = new ArrayList<ServerEndpointConfig>();
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketBundle.class);
    volatile boolean starting = false;
    private ServerEndpointConfig.Configurator defaultConfigurator;

    public WebsocketBundle(ServerEndpointConfig.Configurator defaultConfigurator, Class<?> ... endpoints) {
        this(defaultConfigurator, Arrays.asList(endpoints), new ArrayList<ServerEndpointConfig>());
    }

    public WebsocketBundle(Class<?> ... endpoints) {
        this(null, Arrays.asList(endpoints), new ArrayList<ServerEndpointConfig>());
    }

    public WebsocketBundle(ServerEndpointConfig ... configs) {
        this(null, new ArrayList(), Arrays.asList(configs));
    }

    public WebsocketBundle(ServerEndpointConfig.Configurator defaultConfigurator, Collection<Class<?>> endpointClasses, Collection<ServerEndpointConfig> serverEndpointConfigs) {
        this.defaultConfigurator = defaultConfigurator;
        endpointClasses.forEach(clazz -> this.addEndpoint((Class<?>)clazz));
        this.endpointConfigs.addAll(serverEndpointConfigs);
    }

    public void addEndpoint(ServerEndpointConfig epC) {
        this.endpointConfigs.add(epC);
        if (this.starting) {
            throw new RuntimeException("can't add endpoint after starting lifecycle");
        }
    }

    public void addEndpoint(Class<?> clazz) {
        ServerEndpoint anno = clazz.getAnnotation(ServerEndpoint.class);
        if (anno == null) {
            throw new RuntimeException(clazz.getCanonicalName() + " does not have a " + ServerEndpoint.class.getCanonicalName() + " annotation");
        }
        ServerEndpointConfig.Builder bldr = ServerEndpointConfig.Builder.create(clazz, (String)anno.value());
        if (this.defaultConfigurator != null) {
            bldr = bldr.configurator(this.defaultConfigurator);
        }
        this.endpointConfigs.add(bldr.build());
        if (this.starting) {
            throw new RuntimeException("can't add endpoint after starting lifecycle");
        }
    }

    public void initialize(Bootstrap<?> bootstrap) {
    }

    public void run(final Environment environment) {
        environment.lifecycle().addLifeCycleListener((LifeCycle.Listener)new AbstractLifeCycle.AbstractLifeCycleListener(){

            public void lifeCycleStarting(LifeCycle event) {
                WebsocketBundle.this.starting = true;
                try {
                    ServerContainer wsContainer = InstWebSocketServerContainerInitializer.configureContext(environment.getApplicationContext(), environment.metrics());
                    StringBuilder sb = new StringBuilder("Registering websocket endpoints: ").append(System.lineSeparator()).append(System.lineSeparator());
                    WebsocketBundle.this.endpointConfigs.forEach(GeneralUtils.rethrow(conf -> this.addEndpoint(wsContainer, (ServerEndpointConfig)conf, sb)));
                    LOG.info(sb.toString());
                }
                catch (ServletException ex) {
                    throw new RuntimeException(ex);
                }
            }

            private void addEndpoint(ServerContainer wsContainer, ServerEndpointConfig conf, StringBuilder sb) throws DeploymentException {
                wsContainer.addEndpoint(conf);
                sb.append(String.format("    WS      %s (%s)", conf.getPath(), conf.getEndpointClass().getName())).append(System.lineSeparator());
            }
        });
    }
}

