/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.faas.client;

import com.liveperson.faas.client.IsImplementedCache;
import com.liveperson.faas.client.types.FaaSEventImplementedExpiry;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultIsImplementedCache
implements IsImplementedCache {
    private int isImplementedCacheDurationInSeconds;
    private ConcurrentMap<String, FaaSEventImplementedExpiry> implementationCache = new ConcurrentHashMap<String, FaaSEventImplementedExpiry>();

    DefaultIsImplementedCache(int isImplementedCacheDurationInSeconds) {
        this.isImplementedCacheDurationInSeconds = isImplementedCacheDurationInSeconds;
    }

    @Override
    public void update(String eventId, boolean isImplemented) {
        FaaSEventImplementedExpiry faaSEventImplementedExpiry = new FaaSEventImplementedExpiry();
        faaSEventImplementedExpiry.setExpirationDate(LocalDateTime.now().plusSeconds(this.isImplementedCacheDurationInSeconds));
        faaSEventImplementedExpiry.setImplemented(isImplemented);
        this.implementationCache.put(eventId, faaSEventImplementedExpiry);
    }

    private boolean hasBeenCachedAndIsValid(String eventId) {
        return this.implementationCache.containsKey(eventId) && ((FaaSEventImplementedExpiry)this.implementationCache.get(eventId)).getExpirationDate().isAfter(LocalDateTime.now());
    }

    private void removeIfExpired(String eventId) {
        if (this.implementationCache.containsKey(eventId) && ((FaaSEventImplementedExpiry)this.implementationCache.get(eventId)).getExpirationDate().isBefore(LocalDateTime.now())) {
            this.implementationCache.remove(eventId);
        }
    }

    @Override
    public FaaSEventImplementedExpiry getIfCachedAndValid(String eventId) {
        if (this.hasBeenCachedAndIsValid(eventId)) {
            return (FaaSEventImplementedExpiry)this.implementationCache.get(eventId);
        }
        this.removeIfExpired(eventId);
        return null;
    }
}

