/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.faas.http;

import com.liveperson.faas.exception.RestException;
import com.liveperson.faas.http.RestClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class DefaultRestClient
implements RestClient {
    private int defaultTimeOut = 15000;

    private static void setHeaders(HttpURLConnection connection, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void sendBody(HttpURLConnection connection, String jsonBody) throws IOException {
        OutputStream outputStream = connection.getOutputStream();
        OutputStreamWriter output = new OutputStreamWriter(outputStream, "UTF-8");
        try {
            output.write(jsonBody);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            output.close();
            throw e;
        }
    }

    private static String readResponseBody(InputStream inputStream) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String inputLine;
            StringBuffer content = new StringBuffer();
            while ((inputLine = input.readLine()) != null) {
                content.append(inputLine);
            }
            input.close();
            return content.toString();
        }
        catch (IOException e) {
            input.close();
            throw e;
        }
    }

    @Override
    public String post(String url, Map<String, String> headers, String jsonBody) throws IOException {
        return this.postRequest(url, headers, jsonBody, this.defaultTimeOut);
    }

    @Override
    public String post(String url, Map<String, String> headers, String jsonBody, int timeOutInMs) throws IOException {
        return this.postRequest(url, headers, jsonBody, timeOutInMs);
    }

    @Override
    public String get(String url, Map<String, String> headers, int timeOutInMs) throws IOException {
        return this.getResponse(url, headers, timeOutInMs);
    }

    @Override
    public String get(String url, Map<String, String> headers) throws IOException {
        return this.getResponse(url, headers, this.defaultTimeOut);
    }

    private String postRequest(String url, Map<String, String> headers, String jsonBody, int timeOutInMs) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        try {
            connection.setRequestMethod(HttpMethod.POST.name());
            connection.setRequestProperty("Content-Type", "application/json");
            DefaultRestClient.setHeaders(connection, headers);
            connection.setConnectTimeout((int)((double)timeOutInMs * 0.25));
            connection.setReadTimeout((int)((double)timeOutInMs * 0.75));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            DefaultRestClient.sendBody(connection, jsonBody);
            int status = connection.getResponseCode();
            String response = "";
            if (status >= HttpStatus.BAD_REQUEST.value()) {
                response = DefaultRestClient.readResponseBody(connection.getErrorStream());
                connection.disconnect();
                throw new RestException("Received response code " + status + " for url " + url, response, status);
            }
            response = DefaultRestClient.readResponseBody(connection.getInputStream());
            connection.disconnect();
            return response;
        }
        catch (Exception e) {
            connection.disconnect();
            throw e;
        }
    }

    private String getResponse(String url, Map<String, String> headers, int timeOutInMs) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        try {
            connection.setRequestMethod(HttpMethod.GET.name());
            DefaultRestClient.setHeaders(connection, headers);
            connection.setConnectTimeout((int)((double)timeOutInMs * 0.25));
            connection.setReadTimeout((int)((double)timeOutInMs * 0.75));
            connection.setDoOutput(true);
            connection.setDoInput(true);
            int status = connection.getResponseCode();
            String response = "";
            if (status >= HttpStatus.BAD_REQUEST.value()) {
                connection.disconnect();
                throw new IOException("Received response code " + status + " for url " + url);
            }
            response = DefaultRestClient.readResponseBody(connection.getInputStream());
            connection.disconnect();
            return response;
        }
        catch (Exception e) {
            connection.disconnect();
            throw e;
        }
    }
}

