/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.faas.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.liveperson.faas.csds.CsdsClient;
import com.liveperson.faas.exception.CsdsRetrievalException;
import com.liveperson.faas.exception.TokenGenerationException;
import com.liveperson.faas.http.RestClient;
import com.liveperson.faas.security.AuthExpiryTester;
import com.liveperson.faas.security.BearerGenerator;
import com.liveperson.faas.security.JwtExpiryTester;
import com.liveperson.faas.security.types.Token;
import java.io.IOException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JwtBearerGenerator
implements BearerGenerator {
    static Logger logger = LogManager.getLogger();
    String accountId;
    String clientId;
    String clientSecret;
    private RestClient restClient;
    private CsdsClient csdsClient;
    private String currentJwt;
    private AuthExpiryTester authExpiryTester;

    public JwtBearerGenerator(RestClient restClient, CsdsClient csdsClient, String accountId, String clientId, String clientSecret) {
        this.restClient = restClient;
        this.csdsClient = csdsClient;
        this.accountId = accountId;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authExpiryTester = new JwtExpiryTester();
    }

    @Override
    public String retrieveBearerToken() throws TokenGenerationException {
        block3: {
            if (this.jwtNotInitializedOrAboutToExpire()) {
                try {
                    this.currentJwt = this.generateJwt(this.accountId, this.clientId, this.clientSecret);
                }
                catch (CsdsRetrievalException | IOException e) {
                    logger.warn("There was an error retrieving JTW from Server. " + e);
                    if (!this.jwtFailedToInitializeOrExpired()) break block3;
                    throw new TokenGenerationException("No valid JWT could be retrieved and current one is expired", e);
                }
            }
        }
        return "Bearer " + this.currentJwt;
    }

    private String generateJwt(String accountId, String clientId, String clientSecret) throws CsdsRetrievalException, IOException {
        String sentinelBaseUrl = this.csdsClient.getDomain("sentinel");
        String jwtUrl = String.format("https://%s/sentinel/api/account/%s/app/token?v=2.0&grant_type=client_credentials&client_id=%s&client_secret=%s", sentinelBaseUrl, accountId, clientId, clientSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-type", "application/x-www-form-urlencoded");
        String response = this.restClient.post(jwtUrl, headers, "");
        ObjectMapper mapper = new ObjectMapper();
        Token accessToken = (Token)mapper.readValue(response, Token.class);
        return accessToken.getAccess_token();
    }

    private boolean jwtNotInitializedOrAboutToExpire() {
        return this.currentJwt == null || this.authExpiryTester.isAboutToExpire(this.currentJwt);
    }

    private boolean jwtFailedToInitializeOrExpired() {
        return this.currentJwt == null || this.authExpiryTester.isExpired(this.currentJwt);
    }
}

