/*
 * Decompiled with CFR 0.152.
 */
package com.llama.llamastack.client.local.services.toolruntime;

import com.llama.llamastack.client.local.LocalClientOptions;
import com.llama.llamastack.client.local.services.vectordb.objectbox.RagVectorDb;
import com.llama.llamastack.core.ClientOptions;
import com.llama.llamastack.core.RequestOptions;
import com.llama.llamastack.models.Document;
import com.llama.llamastack.models.QueryResult;
import com.llama.llamastack.models.ToolRuntimeRagToolInsertParams;
import com.llama.llamastack.models.ToolRuntimeRagToolQueryParams;
import com.llama.llamastack.services.blocking.InferenceService;
import com.llama.llamastack.services.blocking.toolRuntime.RagToolService;
import io.objectbox.Box;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bJ2\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\b\b\u0002\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u001d\u001a\u00020\u00012\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\r0\u001fH\u0016J\b\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/llama/llamastack/client/local/services/toolruntime/RagToolServiceLocalImpl;", "Lcom/llama/llamastack/services/blocking/toolRuntime/RagToolService;", "clientOptions", "Lcom/llama/llamastack/client/local/LocalClientOptions;", "inferenceServiceLocalImpl", "Lcom/llama/llamastack/services/blocking/InferenceService;", "(Lcom/llama/llamastack/client/local/LocalClientOptions;Lcom/llama/llamastack/services/blocking/InferenceService;)V", "createChunks", "", "", "params", "Lcom/llama/llamastack/models/ToolRuntimeRagToolInsertParams;", "insert", "", "requestOptions", "Lcom/llama/llamastack/core/RequestOptions;", "vectorDbId", "embeddings", "", "rawChunks", "makeOverlappedChunksFromWords", "text", "documentId", "chunkSize", "", "overlapLen", "query", "Lcom/llama/llamastack/models/QueryResult;", "Lcom/llama/llamastack/models/ToolRuntimeRagToolQueryParams;", "withOptions", "modifier", "Lkotlin/Function1;", "Lcom/llama/llamastack/core/ClientOptions$Builder;", "withRawResponse", "Lcom/llama/llamastack/services/blocking/toolRuntime/RagToolService$WithRawResponse;", "llama-stack-client-kotlin-client-local"})
public final class RagToolServiceLocalImpl
implements RagToolService {
    @NotNull
    private final LocalClientOptions clientOptions;
    @NotNull
    private final InferenceService inferenceServiceLocalImpl;

    public RagToolServiceLocalImpl(@NotNull LocalClientOptions clientOptions, @NotNull InferenceService inferenceServiceLocalImpl) {
        Intrinsics.checkNotNullParameter((Object)clientOptions, (String)"clientOptions");
        Intrinsics.checkNotNullParameter((Object)inferenceServiceLocalImpl, (String)"inferenceServiceLocalImpl");
        this.clientOptions = clientOptions;
        this.inferenceServiceLocalImpl = inferenceServiceLocalImpl;
    }

    @NotNull
    public RagToolService.WithRawResponse withRawResponse() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public RagToolService withOptions(@NotNull Function1<? super ClientOptions.Builder, Unit> modifier) {
        Intrinsics.checkNotNullParameter(modifier, (String)"modifier");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public void insert(@NotNull ToolRuntimeRagToolInsertParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String string = "Not yet implemented. Use other insert() function instead.";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void insert(@NotNull String vectorDbId, @NotNull List<float[]> embeddings, @NotNull List<String> rawChunks) {
        Intrinsics.checkNotNullParameter((Object)vectorDbId, (String)"vectorDbId");
        Intrinsics.checkNotNullParameter(embeddings, (String)"embeddings");
        Intrinsics.checkNotNullParameter(rawChunks, (String)"rawChunks");
        Box<RagVectorDb> box = this.clientOptions.getVectorDb(vectorDbId);
        int n = embeddings.size();
        for (int i = 0; i < n; ++i) {
            RagVectorDb chunk = new RagVectorDb(0L, rawChunks.get(i), embeddings.get(i), 1, null);
            Box<RagVectorDb> box2 = box;
            Intrinsics.checkNotNull(box2);
            box2.put((Object)chunk);
        }
        System.out.println((Object)("Added a total of " + embeddings.size() + " chunks"));
    }

    @NotNull
    public final List<String> createChunks(@NotNull ToolRuntimeRagToolInsertParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Document document = (Document)params.documents().get(0);
        String text = document.content().asString();
        return RagToolServiceLocalImpl.makeOverlappedChunksFromWords$default(this, text, document.documentId(), params.chunkSizeInTokens(), 0L, 8, null);
    }

    @NotNull
    public QueryResult query(@NotNull ToolRuntimeRagToolQueryParams params, @NotNull RequestOptions requestOptions) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)requestOptions, (String)"requestOptions");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final List<String> makeOverlappedChunksFromWords(String text, String documentId, long chunkSize, long overlapLen) {
        CharSequence charSequence = text;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List words = regex.split(charSequence, n);
        List chunks = new ArrayList();
        int n2 = words.size() + -1;
        n = (int)chunkSize - (int)overlapLen;
        if (n <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + n + '.');
        }
        int i = 0;
        int n3 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n2, (int)n);
        int n4 = n;
        if (i <= n3) {
            while (true) {
                int end = Math.min(i + (int)chunkSize, words.size());
                chunks.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice((List)words, (IntRange)RangesKt.until((int)i, (int)end)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
                if (i == n3) break;
                i += n4;
            }
        }
        return chunks;
    }

    static /* synthetic */ List makeOverlappedChunksFromWords$default(RagToolServiceLocalImpl ragToolServiceLocalImpl, String string, String string2, long l, long l2, int n, Object object) {
        if ((n & 4) != 0) {
            l = 50L;
        }
        if ((n & 8) != 0) {
            l2 = 10L;
        }
        return ragToolServiceLocalImpl.makeOverlappedChunksFromWords(string, string2, l, l2);
    }
}

