/*
 * Decompiled with CFR 0.152.
 */
package com.llama.llamastack.client.local.util;

import com.llama.llamastack.core.JsonValue;
import com.llama.llamastack.models.AgentTurnResponseStreamChunk;
import com.llama.llamastack.models.ChatCompletionResponse;
import com.llama.llamastack.models.ChatCompletionResponseStreamChunk;
import com.llama.llamastack.models.CompletionMessage;
import com.llama.llamastack.models.ContentDelta;
import com.llama.llamastack.models.InferenceStep;
import com.llama.llamastack.models.InterleavedContent;
import com.llama.llamastack.models.ToolCall;
import com.llama.llamastack.models.TurnResponseEvent;
import com.llama.llamastack.models.TurnResponseEventPayload;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0006\u001a\u001e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0006\u001a$\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a$\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u0006\u001a\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u001e"}, d2={"buildAgentTurnResponseForCustomToolCallStream", "Lcom/llama/llamastack/models/AgentTurnResponseStreamChunk;", "toolCalls", "", "Lcom/llama/llamastack/models/ToolCall;", "stopToken", "", "stats", "", "buildAgentTurnResponseFromStream", "response", "buildAgentTurnResponseFromStringStream", "buildInferenceChatCompletionResponse", "Lcom/llama/llamastack/models/ChatCompletionResponse;", "buildInferenceChatCompletionResponseForCustomToolCallStream", "Lcom/llama/llamastack/models/ChatCompletionResponseStreamChunk;", "toolCall", "buildInferenceChatCompletionResponseForStringStream", "str", "buildInferenceChatCompletionResponseFromStream", "buildLastAgentTurnResponsesFromStream", "resultMessage", "buildLastInferenceChatCompletionResponsesFromStream", "createCustomToolCalls", "isResponseAToolCall", "", "mapStopTokenToReason", "Lcom/llama/llamastack/models/CompletionMessage$StopReason;", "mapStopTokenToReasonForStream", "Lcom/llama/llamastack/models/ChatCompletionResponseStreamChunk$Event$StopReason;", "llama-stack-client-kotlin-client-local"})
public final class ResponseUtilKt {
    @NotNull
    public static final ChatCompletionResponse buildInferenceChatCompletionResponse(@NotNull String response, float stats, @NotNull String stopToken) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        CompletionMessage completionMessage = ResponseUtilKt.isResponseAToolCall(response) ? CompletionMessage.Companion.builder().toolCalls(ResponseUtilKt.createCustomToolCalls(response)).content(InterleavedContent.Companion.ofString("")).stopReason(ResponseUtilKt.mapStopTokenToReason(stopToken)).build() : CompletionMessage.Companion.builder().toolCalls(CollectionsKt.emptyList()).content(InterleavedContent.Companion.ofString(response)).stopReason(ResponseUtilKt.mapStopTokenToReason(stopToken)).build();
        ChatCompletionResponse inferenceChatCompletionResponse = ChatCompletionResponse.Companion.builder().completionMessage(completionMessage).putAdditionalProperty("tps", JsonValue.Companion.from((Object)Float.valueOf(stats))).build();
        return inferenceChatCompletionResponse;
    }

    @NotNull
    public static final ChatCompletionResponseStreamChunk buildInferenceChatCompletionResponseFromStream(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return ChatCompletionResponseStreamChunk.Companion.builder().event(ChatCompletionResponseStreamChunk.Event.Companion.builder().delta(ContentDelta.Text.Companion.builder().text(response).build()).eventType(ChatCompletionResponseStreamChunk.Event.EventType.Companion.getPROGRESS()).build()).build();
    }

    @NotNull
    public static final List<ChatCompletionResponseStreamChunk> buildLastInferenceChatCompletionResponsesFromStream(@NotNull String resultMessage, float stats, @NotNull String stopToken) {
        Intrinsics.checkNotNullParameter((Object)resultMessage, (String)"resultMessage");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        List listOfResponses = new ArrayList();
        if (ResponseUtilKt.isResponseAToolCall(resultMessage)) {
            List<ToolCall> toolCalls = ResponseUtilKt.createCustomToolCalls(resultMessage);
            for (ToolCall toolCall : toolCalls) {
                listOfResponses.add(ResponseUtilKt.buildInferenceChatCompletionResponseForCustomToolCallStream(toolCall, stopToken, stats));
            }
        } else {
            ResponseUtilKt.buildInferenceChatCompletionResponseForStringStream("", stopToken, stats);
        }
        return CollectionsKt.toList((Iterable)listOfResponses);
    }

    @NotNull
    public static final ChatCompletionResponseStreamChunk buildInferenceChatCompletionResponseForCustomToolCallStream(@NotNull ToolCall toolCall, @NotNull String stopToken, float stats) {
        Intrinsics.checkNotNullParameter((Object)toolCall, (String)"toolCall");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        ContentDelta.ToolCall delta = ContentDelta.ToolCall.Companion.builder().parseStatus(ContentDelta.ToolCall.ParseStatus.Companion.getSUCCEEDED()).toolCall(toolCall.toString()).build();
        return ChatCompletionResponseStreamChunk.Companion.builder().event(ChatCompletionResponseStreamChunk.Event.Companion.builder().delta(delta).stopReason(ResponseUtilKt.mapStopTokenToReasonForStream(stopToken)).eventType(ChatCompletionResponseStreamChunk.Event.EventType.Companion.getPROGRESS()).build()).putAdditionalProperty("tps", JsonValue.Companion.from((Object)Float.valueOf(stats))).build();
    }

    @NotNull
    public static final ChatCompletionResponseStreamChunk buildInferenceChatCompletionResponseForStringStream(@NotNull String str, @NotNull String stopToken, float stats) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        return ChatCompletionResponseStreamChunk.Companion.builder().event(ChatCompletionResponseStreamChunk.Event.Companion.builder().delta(ContentDelta.Text.Companion.builder().text(str).build()).stopReason(ResponseUtilKt.mapStopTokenToReasonForStream(stopToken)).eventType(ChatCompletionResponseStreamChunk.Event.EventType.Companion.getPROGRESS()).putAdditionalProperty("tps", JsonValue.Companion.from((Object)Float.valueOf(stats))).build()).build();
    }

    @NotNull
    public static final AgentTurnResponseStreamChunk buildAgentTurnResponseFromStream(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return AgentTurnResponseStreamChunk.Companion.builder().event(TurnResponseEvent.Companion.builder().payload(TurnResponseEventPayload.StepProgress.Companion.builder().delta(ContentDelta.Text.Companion.builder().text(response).build()).stepId("0").stepType(TurnResponseEventPayload.StepProgress.StepType.Companion.getINFERENCE()).build()).build()).build();
    }

    @NotNull
    public static final List<AgentTurnResponseStreamChunk> buildLastAgentTurnResponsesFromStream(@NotNull String resultMessage, float stats, @NotNull String stopToken) {
        Intrinsics.checkNotNullParameter((Object)resultMessage, (String)"resultMessage");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        List listOfResponses = new ArrayList();
        if (ResponseUtilKt.isResponseAToolCall(resultMessage)) {
            List<ToolCall> toolCalls = ResponseUtilKt.createCustomToolCalls(resultMessage);
            System.out.println((Object)("determined tool call is " + toolCalls));
            listOfResponses.add(ResponseUtilKt.buildAgentTurnResponseForCustomToolCallStream(toolCalls, stopToken, stats));
        } else {
            listOfResponses.add(ResponseUtilKt.buildAgentTurnResponseFromStringStream("", stopToken, stats));
            System.out.println((Object)"not a tool call");
        }
        return CollectionsKt.toList((Iterable)listOfResponses);
    }

    @NotNull
    public static final AgentTurnResponseStreamChunk buildAgentTurnResponseForCustomToolCallStream(@NotNull List<ToolCall> toolCalls, @NotNull String stopToken, float stats) {
        Intrinsics.checkNotNullParameter(toolCalls, (String)"toolCalls");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        return AgentTurnResponseStreamChunk.Companion.builder().event(TurnResponseEvent.Companion.builder().payload(TurnResponseEventPayload.StepComplete.Companion.builder().stepDetails(InferenceStep.Companion.builder().modelResponse(CompletionMessage.Companion.builder().content("").stopReason(ResponseUtilKt.mapStopTokenToReason(stopToken)).toolCalls(toolCalls).build()).turnId("0").stepId("0").build()).stepId("0").stepType(TurnResponseEventPayload.StepComplete.StepType.Companion.getINFERENCE()).build()).build()).build();
    }

    @NotNull
    public static final AgentTurnResponseStreamChunk buildAgentTurnResponseFromStringStream(@NotNull String response, @NotNull String stopToken, float stats) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        return AgentTurnResponseStreamChunk.Companion.builder().event(TurnResponseEvent.Companion.builder().payload(TurnResponseEventPayload.StepComplete.Companion.builder().stepDetails(InferenceStep.Companion.builder().modelResponse(CompletionMessage.Companion.builder().content("").stopReason(ResponseUtilKt.mapStopTokenToReason(stopToken)).build()).turnId("0").stepId("0").build()).stepId("0").stepType(TurnResponseEventPayload.StepComplete.StepType.Companion.getINFERENCE()).putAdditionalProperty("tps", JsonValue.Companion.from((Object)Float.valueOf(stats))).build()).build()).build();
    }

    public static final boolean isResponseAToolCall(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return StringsKt.startsWith$default((String)response, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)response, (String)"]", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final List<ToolCall> createCustomToolCalls(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        List toolCalls = new ArrayList();
        String[] stringArray = new String[]{"),"};
        List splitsResponse = StringsKt.split$default((CharSequence)response, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        for (String split : splitsResponse) {
            String toolName;
            String paramsString;
            String formattedSplit = StringsKt.endsWith$default((CharSequence)split, (char)')', (boolean)false, (int)2, null) ? split : split + ')';
            int startIndex = StringsKt.indexOf$default((CharSequence)formattedSplit, (char)'(', (int)0, (boolean)false, (int)6, null);
            int endIndex = StringsKt.indexOf$default((CharSequence)formattedSplit, (char)')', (int)0, (boolean)false, (int)6, null);
            Intrinsics.checkNotNullExpressionValue((Object)formattedSplit.substring(1, startIndex), (String)"substring(...)");
            Intrinsics.checkNotNullExpressionValue((Object)formattedSplit.substring(startIndex + 1, endIndex), (String)"substring(...)");
            Map paramsJson = new LinkedHashMap();
            String[] stringArray2 = new String[]{", "};
            List paramsList = StringsKt.split$default((CharSequence)paramsString, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            for (String param : paramsList) {
                String[] stringArray3;
                List keyValue = StringsKt.split$default((CharSequence)param, (String[])(stringArray3 = new String[]{"="}), (boolean)false, (int)0, (int)6, null);
                if (keyValue.size() != 2) continue;
                String key = ((Object)StringsKt.trim((CharSequence)((String)keyValue.get(0)))).toString();
                String value = StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)((String)keyValue.get(1)))).toString(), (String)"'", (String)"", (boolean)false, (int)4, null), (String)"\"", (String)"", (boolean)false, (int)4, null);
                paramsJson.put(key, JsonValue.Companion.from((Object)value));
            }
            ToolCall.Builder builder = ToolCall.Companion.builder().toolName(toolName).arguments(ToolCall.Arguments.UnionMember1.Companion.builder().additionalProperties(paramsJson).build());
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            toolCalls.add(builder.callId(string).build());
        }
        return CollectionsKt.toList((Iterable)toolCalls);
    }

    @NotNull
    public static final CompletionMessage.StopReason mapStopTokenToReason(@NotNull String stopToken) {
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        String string = stopToken;
        return Intrinsics.areEqual((Object)string, (Object)"<|eot_id|>") ? CompletionMessage.StopReason.Companion.getEND_OF_TURN() : (Intrinsics.areEqual((Object)string, (Object)"<|eom_id|>") ? CompletionMessage.StopReason.Companion.getEND_OF_MESSAGE() : CompletionMessage.StopReason.Companion.getOUT_OF_TOKENS());
    }

    @NotNull
    public static final ChatCompletionResponseStreamChunk.Event.StopReason mapStopTokenToReasonForStream(@NotNull String stopToken) {
        Intrinsics.checkNotNullParameter((Object)stopToken, (String)"stopToken");
        String string = stopToken;
        return Intrinsics.areEqual((Object)string, (Object)"<|eot_id|>") ? ChatCompletionResponseStreamChunk.Event.StopReason.Companion.getEND_OF_TURN() : (Intrinsics.areEqual((Object)string, (Object)"<|eom_id|>") ? ChatCompletionResponseStreamChunk.Event.StopReason.Companion.getEND_OF_MESSAGE() : ChatCompletionResponseStreamChunk.Event.StopReason.Companion.getOUT_OF_TOKENS());
    }
}

