/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor;

import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.tool.disruptor.DisruptorProxy;
import com.lmax.tool.disruptor.RingBufferProxyValidation;
import com.lmax.tool.disruptor.ValidationConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

public final class ConfigurableValidator
implements RingBufferProxyValidation,
ValidationConfig {
    private final boolean validateProxyInterfaces;
    private final boolean validateExceptionHandler;

    public ConfigurableValidator(ValidationConfig.ProxyInterface proxyInterfaceConfiguration, ValidationConfig.ExceptionHandler exceptionHandlerConfiguration) {
        this(proxyInterfaceConfiguration.shouldValidateProxyInterfaces(), exceptionHandlerConfiguration.shouldValidateExceptionHandler());
    }

    public ConfigurableValidator(boolean validateProxyInterfaces, boolean validateExceptionHandler) {
        this.validateProxyInterfaces = validateProxyInterfaces;
        this.validateExceptionHandler = validateExceptionHandler;
    }

    public ConfigurableValidator(ValidationConfig validationConfig) {
        this(validationConfig.validateProxyInterfaces(), validationConfig.validateExceptionHandler());
    }

    @Override
    public void validateAll(Disruptor<?> disruptor, Class<?> disruptorProxyInterface) {
        this.ensureThatProxyInterfaceIsAnInterface(disruptorProxyInterface);
        this.ensureDisruptorInstanceHasAnExceptionHandler(disruptor);
        this.ensureDisruptorProxyIsAnnotatedWithDisruptorProxyAnnotation(disruptorProxyInterface);
    }

    private void ensureThatProxyInterfaceIsAnInterface(Class<?> disruptorProxyInterface) {
        if (!disruptorProxyInterface.isInterface()) {
            throw new IllegalArgumentException("Not an interface: " + disruptorProxyInterface);
        }
    }

    private void ensureDisruptorInstanceHasAnExceptionHandler(Disruptor<?> disruptor) {
        if (!this.validateExceptionHandler) {
            return;
        }
        try {
            Field field = Disruptor.class.getDeclaredField("exceptionHandler");
            field.setAccessible(true);
            if (field.get(disruptor) == null) {
                throw new IllegalStateException("Please supply an ExceptionHandler to the Disruptor instance. The default Disruptor behaviour is to stop processing when an exception occurs.");
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to inspect Disruptor instance", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to inspect Disruptor instance", e);
        }
    }

    void ensureDisruptorProxyIsAnnotatedWithDisruptorProxyAnnotation(Class<?> disruptorProxyInterface) {
        if (!this.validateProxyInterfaces) {
            return;
        }
        for (Annotation annotation : disruptorProxyInterface.getAnnotations()) {
            if (!(annotation instanceof DisruptorProxy)) continue;
            return;
        }
        throw new IllegalArgumentException("Please supply a disruptor proxy interface that is annotated with " + DisruptorProxy.class);
    }

    @Override
    public boolean validateProxyInterfaces() {
        return this.validateProxyInterfaces;
    }

    @Override
    public boolean validateExceptionHandler() {
        return this.validateExceptionHandler;
    }
}

