/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor;

import com.lmax.disruptor.EventHandler;
import com.lmax.tool.disruptor.BatchListener;
import com.lmax.tool.disruptor.ProxyMethodInvocation;

public final class InvokerEventHandler<T>
implements EventHandler<ProxyMethodInvocation> {
    private final T implementation;
    private final boolean isBatchListener;
    private final boolean reset;

    public InvokerEventHandler(T implementation, boolean reset) {
        this.implementation = implementation;
        this.reset = reset;
        this.isBatchListener = implementation instanceof BatchListener;
    }

    public InvokerEventHandler(T implementation) {
        this(implementation, true);
    }

    public void onEvent(ProxyMethodInvocation event, long sequence, boolean endOfBatch) throws Exception {
        event.getInvoker().invokeWithArgumentHolder(this.implementation, event.getArgumentHolder());
        if (this.reset) {
            event.reset();
        }
        if (this.isBatchListener && endOfBatch) {
            BatchListener batchListener = (BatchListener)this.implementation;
            batchListener.onEndOfBatch();
        }
    }
}

