/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor;

import com.lmax.tool.disruptor.ConfigurableValidator;
import com.lmax.tool.disruptor.DropListener;
import com.lmax.tool.disruptor.GeneratorType;
import com.lmax.tool.disruptor.MessagePublicationListener;
import com.lmax.tool.disruptor.NoMessagePublicationListener;
import com.lmax.tool.disruptor.NoOpDropListener;
import com.lmax.tool.disruptor.RingBufferProxyGenerator;
import com.lmax.tool.disruptor.RingBufferProxyValidation;
import com.lmax.tool.disruptor.ValidationConfig;
import java.lang.reflect.Constructor;

public final class RingBufferProxyGeneratorFactory {
    public RingBufferProxyGenerator newProxy(GeneratorType generatorType) {
        ConfigurableValidator validateAsMuchAsPossibleValidator = new ConfigurableValidator(true, true);
        return this.newProxy(generatorType, validateAsMuchAsPossibleValidator);
    }

    public RingBufferProxyGenerator newProxy(GeneratorType generatorType, ValidationConfig config) {
        return this.newProxy(generatorType, config, NoOpDropListener.INSTANCE);
    }

    public RingBufferProxyGenerator newProxy(GeneratorType generatorType, ValidationConfig config, DropListener dropListener) {
        return this.newProxy(generatorType, config, dropListener, NoMessagePublicationListener.INSTANCE);
    }

    public RingBufferProxyGenerator newProxy(GeneratorType generatorType, ValidationConfig config, DropListener dropListener, MessagePublicationListener messagePublicationListener) {
        try {
            Class<?> clazz = Class.forName(generatorType.getGeneratorClassName());
            ConfigurableValidator validator = new ConfigurableValidator(config.validateProxyInterfaces(), config.validateExceptionHandler());
            Constructor<?> constructorForRingBufferProxyGenerator = clazz.getConstructor(RingBufferProxyValidation.class, DropListener.class, MessagePublicationListener.class);
            return (RingBufferProxyGenerator)constructorForRingBufferProxyGenerator.newInstance(validator, dropListener, messagePublicationListener);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unable to instantiate generator %s", generatorType.getGeneratorClassName()), e);
        }
    }

    @Deprecated
    public RingBufferProxyGenerator create(GeneratorType generatorType) {
        ConfigurableValidator backwardsCompatibleValidator = new ConfigurableValidator(false, true);
        return this.newProxy(generatorType, backwardsCompatibleValidator);
    }
}

