/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor.bytecode;

import com.lmax.tool.disruptor.Resetable;
import com.lmax.tool.disruptor.bytecode.ArgumentHolderHelper;
import com.lmax.tool.disruptor.bytecode.ByteCodeHelper;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewConstructor;

final class ArgumentHolderGenerator {
    private final ArgumentHolderHelper helper = new ArgumentHolderHelper();
    private final ClassPool classPool;
    private String generatedClassName;
    private Class<?> generatedClass;
    private Map<Class<?>, Integer> parameterTypeCounts;
    private Map<Class<?>, Character> parameterFieldSuffix = new HashMap();

    public ArgumentHolderGenerator(ClassPool classPool) {
        this.classPool = classPool;
    }

    public void createArgumentHolderClass(Class<?> proxyInterface) {
        CtClass ctClass = ByteCodeHelper.makeClass(this.classPool, "_argumentHolder_" + proxyInterface.getSimpleName() + "_" + ByteCodeHelper.getUniqueIdentifier());
        this.parameterTypeCounts = this.helper.getParameterTypeCounts(proxyInterface);
        this.createFields(ctClass);
        ByteCodeHelper.createMethod(ctClass, this.generateResetMethod());
        ByteCodeHelper.addInterface(ctClass, Resetable.class, this.classPool);
        try {
            ctClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)ctClass));
            ByteCodeHelper.makePublicFinal(ctClass);
            this.generatedClass = ctClass.toClass();
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Cannot generate argument holder object", e);
        }
        this.generatedClassName = ctClass.getName();
    }

    public void resetFieldNames() {
        this.parameterFieldSuffix.clear();
        for (Class<?> parameterType : this.parameterTypeCounts.keySet()) {
            this.parameterFieldSuffix.put(parameterType, Character.valueOf('a'));
        }
    }

    public String getNextFieldNameForType(Class<?> parameterType) {
        Character suffix = this.parameterFieldSuffix.get(parameterType);
        this.parameterFieldSuffix.put(parameterType, Character.valueOf((char)(suffix.charValue() + '\u0001')));
        return ArgumentHolderGenerator.getSanitisedFieldName(parameterType) + "_" + suffix;
    }

    public String getGeneratedClassName() {
        return this.generatedClassName;
    }

    public Class<?> getGeneratedClass() {
        return this.generatedClass;
    }

    private void createFields(CtClass ctClass) {
        for (Map.Entry<Class<?>, Integer> entry : this.parameterTypeCounts.entrySet()) {
            StringBuilder buffer = new StringBuilder();
            int suffix = 97;
            int parameterCount = entry.getValue();
            Class<?> parameterType = entry.getKey();
            String parameterTypeName = ArgumentHolderGenerator.sanitiseParameterType(parameterType);
            for (int i = 0; i < parameterCount; ++i) {
                buffer.setLength(0);
                buffer.append("public ").append(parameterTypeName).append(' ');
                buffer.append(ArgumentHolderGenerator.sanitiseParameterName(parameterTypeName));
                buffer.append('_').append((char)(97 + i));
                buffer.append(";\n");
                ByteCodeHelper.createField(ctClass, buffer.toString());
            }
        }
    }

    private String generateResetMethod() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("public void reset() {\n");
        for (Map.Entry<Class<?>, Integer> entry : this.parameterTypeCounts.entrySet()) {
            int suffix = 97;
            int parameterCount = entry.getValue();
            Class<?> parameterType = entry.getKey();
            if (parameterType.isPrimitive()) continue;
            for (int i = 0; i < parameterCount; ++i) {
                buffer.append(ArgumentHolderGenerator.getSanitisedFieldName(parameterType)).append("_").append((char)(97 + i)).append(" = null;\n");
            }
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    private static String getSanitisedFieldName(Class<?> parameterType) {
        return ArgumentHolderGenerator.sanitiseParameterName(ArgumentHolderGenerator.sanitiseParameterType(parameterType));
    }

    private static String sanitiseParameterName(String parameterTypeName) {
        return parameterTypeName.replace('[', '_').replace(']', '_').replace('.', '_');
    }

    private static String sanitiseParameterType(Class<?> parameterType) {
        if (parameterType.isArray()) {
            return parameterType.getComponentType().getName() + "[]";
        }
        return parameterType.getName();
    }
}

