/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor.bytecode;

import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;

enum ByteCodeHelper {
    INSTANCE;

    private static final AtomicInteger UNIQUE_GENERATED_CLASS_NAME_COUNTER;
    static final boolean DEBUG = false;

    static int getUniqueIdentifier() {
        return UNIQUE_GENERATED_CLASS_NAME_COUNTER.incrementAndGet();
    }

    static CtClass makeClass(ClassPool classPool, String className) {
        return classPool.makeClass(className);
    }

    static void createMethod(CtClass ctClass, String methodSrc) {
        try {
            ctClass.addMethod(CtMethod.make((String)methodSrc, (CtClass)ctClass));
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to compile class", e);
        }
    }

    static void createField(CtClass ctClass, String fieldSrc) {
        try {
            ctClass.addField(CtField.make((String)fieldSrc, (CtClass)ctClass));
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to generate field: " + fieldSrc, e);
        }
    }

    static void makePublicFinal(CtClass ctClass) {
        ctClass.setModifiers(17);
    }

    static void addInterface(CtClass ctClass, Class<?> interfaceClass, ClassPool classPool) {
        try {
            ctClass.addInterface(classPool.get(interfaceClass.getName()));
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Cannot load class: " + interfaceClass.getName(), e);
        }
    }

    static {
        UNIQUE_GENERATED_CLASS_NAME_COUNTER = new AtomicInteger();
    }
}

