/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor.bytecode;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.tool.disruptor.DropListener;
import com.lmax.tool.disruptor.Invoker;
import com.lmax.tool.disruptor.InvokerEventHandler;
import com.lmax.tool.disruptor.MessagePublicationListener;
import com.lmax.tool.disruptor.NoMessagePublicationListener;
import com.lmax.tool.disruptor.NoOpDropListener;
import com.lmax.tool.disruptor.OverflowStrategy;
import com.lmax.tool.disruptor.ProxyMethodInvocation;
import com.lmax.tool.disruptor.ResetHandler;
import com.lmax.tool.disruptor.Resetable;
import com.lmax.tool.disruptor.RingBufferProxyGenerator;
import com.lmax.tool.disruptor.RingBufferProxyValidation;
import com.lmax.tool.disruptor.bytecode.ArgumentHolderGenerator;
import com.lmax.tool.disruptor.bytecode.ByteCodeHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.LoaderClassPath;
import javassist.NotFoundException;

public final class GeneratedRingBufferProxyGenerator
implements RingBufferProxyGenerator {
    private final ClassPool classPool;
    private final RingBufferProxyValidation validator;
    private final DropListener dropListener;
    private final MessagePublicationListener messagePublicationListener;

    public GeneratedRingBufferProxyGenerator(RingBufferProxyValidation validator) {
        this(validator, NoOpDropListener.INSTANCE);
    }

    public GeneratedRingBufferProxyGenerator(RingBufferProxyValidation validator, DropListener dropListener) {
        this(validator, dropListener, NoMessagePublicationListener.INSTANCE);
    }

    public GeneratedRingBufferProxyGenerator(RingBufferProxyValidation validator, DropListener dropListener, MessagePublicationListener messagePublicationListener) {
        this.validator = validator;
        this.dropListener = dropListener;
        this.messagePublicationListener = messagePublicationListener;
        this.classPool = GeneratedRingBufferProxyGenerator.configureClassPool();
    }

    @Override
    public <T> T createRingBufferProxy(Class<T> proxyInterface, Disruptor<ProxyMethodInvocation> disruptor, OverflowStrategy overflowStrategy, T implementation) {
        this.validator.validateAll(disruptor, proxyInterface);
        disruptor.handleEventsWith(new EventHandler[]{new InvokerEventHandler<T>(implementation)});
        ArgumentHolderGenerator argumentHolderGenerator = new ArgumentHolderGenerator(this.classPool);
        argumentHolderGenerator.createArgumentHolderClass(proxyInterface);
        this.prefillArgumentHolderObjects((RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer(), argumentHolderGenerator);
        Map<Method, Invoker> methodToInvokerMap = this.createMethodToInvokerMap(proxyInterface, argumentHolderGenerator);
        return this.generateProxy(proxyInterface, (RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer(), methodToInvokerMap, overflowStrategy, argumentHolderGenerator);
    }

    @Override
    public <T> T createRingBufferProxy(Class<T> proxyInterface, Disruptor<ProxyMethodInvocation> disruptor, OverflowStrategy overflowStrategy, T ... implementations) {
        this.validator.validateAll(disruptor, proxyInterface);
        if (implementations.length < 1) {
            throw new IllegalArgumentException("Must have at least one implementation");
        }
        if (implementations.length == 1) {
            return this.createRingBufferProxy(proxyInterface, disruptor, overflowStrategy, implementations[0]);
        }
        EventHandler[] handlers = new InvokerEventHandler[implementations.length];
        for (int i = 0; i < implementations.length; ++i) {
            handlers[i] = new InvokerEventHandler<T>(implementations[i], false);
            disruptor.handleEventsWith(new EventHandler[]{handlers[i]});
        }
        disruptor.after(handlers).then(new EventHandler[]{new ResetHandler()});
        ArgumentHolderGenerator argumentHolderGenerator = new ArgumentHolderGenerator(this.classPool);
        argumentHolderGenerator.createArgumentHolderClass(proxyInterface);
        this.prefillArgumentHolderObjects((RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer(), argumentHolderGenerator);
        Map<Method, Invoker> methodToInvokerMap = this.createMethodToInvokerMap(proxyInterface, argumentHolderGenerator);
        return this.generateProxy(proxyInterface, (RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer(), methodToInvokerMap, overflowStrategy, argumentHolderGenerator);
    }

    private void prefillArgumentHolderObjects(RingBuffer<ProxyMethodInvocation> ringBuffer, ArgumentHolderGenerator argumentHolderGenerator) {
        int bufferSize = ringBuffer.getBufferSize();
        for (int i = 0; i < bufferSize; ++i) {
            ((ProxyMethodInvocation)ringBuffer.get((long)i)).setArgumentHolder((Resetable)this.instantiate(argumentHolderGenerator.getGeneratedClass(), new Class[0], new Object[0]));
        }
    }

    private <T> T generateProxy(Class<T> proxyInterface, RingBuffer<ProxyMethodInvocation> ringBuffer, Map<Method, Invoker> methodToInvokerMap, OverflowStrategy overflowStrategy, ArgumentHolderGenerator argumentHolderGenerator) {
        CtClass ctClass = ByteCodeHelper.makeClass(this.classPool, "_proxy" + proxyInterface.getSimpleName() + '_' + ByteCodeHelper.getUniqueIdentifier());
        ByteCodeHelper.addInterface(ctClass, proxyInterface, this.classPool);
        ByteCodeHelper.makePublicFinal(ctClass);
        this.createFields(methodToInvokerMap, ctClass);
        this.createConstructor(ctClass);
        for (Method method : proxyInterface.getMethods()) {
            this.createRingBufferPublisherMethod(ctClass, method, methodToInvokerMap.get(method), overflowStrategy, argumentHolderGenerator);
        }
        return this.instantiateProxy(ctClass, ringBuffer);
    }

    private <T> T instantiateProxy(CtClass ctClass, RingBuffer<ProxyMethodInvocation> ringBuffer) {
        try {
            return this.instantiate(ctClass.toClass(), new Class[]{RingBuffer.class, DropListener.class, MessagePublicationListener.class}, ringBuffer, this.dropListener, this.messagePublicationListener);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to compile class", e);
        }
    }

    private <T> T instantiate(Class generatedClass, Class[] constructorArgumentTypes, Object ... args) {
        try {
            Constructor jdkConstructor = generatedClass.getConstructor(constructorArgumentTypes);
            return jdkConstructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Unable to instantiate class", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to instantiate class", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to instantiate class", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate class", e);
        }
    }

    private void createConstructor(CtClass ctClass) {
        try {
            CtConstructor ctConstructor = new CtConstructor(new CtClass[]{this.classPool.getCtClass(RingBuffer.class.getName()), this.classPool.getCtClass(DropListener.class.getName()), this.classPool.getCtClass(MessagePublicationListener.class.getName())}, ctClass);
            ctConstructor.setBody("{ringBuffer = $1;dropListener = $2;messagePublicationListener = $3;}");
            ctClass.addConstructor(ctConstructor);
        }
        catch (NotFoundException e) {
            throw new RuntimeException("Unable to create constructor", e);
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to create constructor", e);
        }
    }

    private void createFields(Map<Method, Invoker> methodToInvokerMap, CtClass ctClass) {
        ByteCodeHelper.createField(ctClass, "private final " + RingBuffer.class.getName() + " ringBuffer;");
        ByteCodeHelper.createField(ctClass, "private final " + DropListener.class.getName() + " dropListener;");
        ByteCodeHelper.createField(ctClass, "private final " + MessagePublicationListener.class.getName() + " messagePublicationListener;");
        for (Method method : methodToInvokerMap.keySet()) {
            Invoker invoker = methodToInvokerMap.get(method);
            ByteCodeHelper.createField(ctClass, "private final " + invoker.getClass().getName() + " _" + invoker.getClass().getName() + " = new " + invoker.getClass().getName() + "();");
        }
    }

    private void createRingBufferPublisherMethod(CtClass ctClass, Method method, Invoker invoker, OverflowStrategy overflowStrategy, ArgumentHolderGenerator argumentHolderGenerator) {
        Class<?> parameterType;
        StringBuilder methodSrc = new StringBuilder("public void ").append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        char paramId = 'a';
        int parameterTypesLength = parameterTypes.length;
        for (int i = 0; i < parameterTypesLength; ++i) {
            parameterType = parameterTypes[i];
            if (parameterType.isArray()) {
                char c = paramId;
                paramId = (char)(paramId + 1);
                methodSrc.append(parameterType.getComponentType().getName()).append("[] ").append(c);
            } else {
                char c = paramId;
                paramId = (char)(paramId + 1);
                methodSrc.append(parameterType.getName()).append(' ').append(c);
            }
            if (i >= parameterTypesLength - 1) continue;
            methodSrc.append(", ");
        }
        methodSrc.append(")\n{\n");
        methodSrc.append("messagePublicationListener.onPrePublish();\n");
        this.handleOverflowStrategy(overflowStrategy, methodSrc);
        methodSrc.append("final long sequence = ringBuffer.next();\n").append("try\n").append("{\n").append("final ProxyMethodInvocation proxyMethodInvocation = (ProxyMethodInvocation) ringBuffer.get(sequence);\n");
        String argumentHolderClass = argumentHolderGenerator.getGeneratedClassName();
        methodSrc.append("final ").append(argumentHolderClass).append(" holder = (").append(argumentHolderClass).append(") proxyMethodInvocation.getArgumentHolder();\n");
        argumentHolderGenerator.resetFieldNames();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterType = parameterTypes[i];
            String holderField = argumentHolderGenerator.getNextFieldNameForType(parameterType);
            methodSrc.append("holder.").append(holderField).append(" = ").append((char)(97 + i)).append(";");
        }
        methodSrc.append("proxyMethodInvocation.setInvoker(_").append(invoker.getClass().getName()).append(");\n").append("}\n").append("catch(Throwable t){t.printStackTrace();}\n").append("finally\n").append("{\n").append("ringBuffer.publish(sequence);\n").append("messagePublicationListener.onPostPublish();\n").append("}\n");
        methodSrc.append("}\n");
        ByteCodeHelper.createMethod(ctClass, methodSrc.toString());
    }

    private void handleOverflowStrategy(OverflowStrategy overflowStrategy, StringBuilder methodSrc) {
        if (overflowStrategy == OverflowStrategy.DROP) {
            methodSrc.append("if(!ringBuffer.hasAvailableCapacity(1))\n");
            methodSrc.append("{");
            methodSrc.append("dropListener.onDrop();");
            methodSrc.append("return;\n");
            methodSrc.append("}\n");
        }
    }

    private <T> Invoker generateInvoker(Class<T> proxyInterface, Method method, ArgumentHolderGenerator argumentHolderGenerator) {
        Class<?>[] parameterTypes;
        StringBuilder invokerClassName = new StringBuilder("_invoker").append(proxyInterface.getSimpleName()).append(method.getName()).append('_').append(ByteCodeHelper.getUniqueIdentifier());
        for (Class<?> paramType : parameterTypes = method.getParameterTypes()) {
            if (paramType.isArray()) {
                invokerClassName.append(paramType.getComponentType().getSimpleName()).append("Array");
                continue;
            }
            invokerClassName.append(paramType.getSimpleName());
        }
        CtClass ctClass = ByteCodeHelper.makeClass(this.classPool, invokerClassName.toString());
        ByteCodeHelper.addInterface(ctClass, Invoker.class, this.classPool);
        ByteCodeHelper.makePublicFinal(ctClass);
        StringBuilder methodSrc = new StringBuilder("public void invokeWithArgumentHolder(").append("Object").append(" implementation, Object argumentHolder) {\n");
        if (parameterTypes.length != 0) {
            methodSrc.append("final ").append(argumentHolderGenerator.getGeneratedClassName()).append(" holder = ").append("(").append(argumentHolderGenerator.getGeneratedClassName()).append(") argumentHolder;\n");
        }
        methodSrc.append("((").append(proxyInterface.getName().replace('$', '.')).append(")implementation).").append(method.getName()).append('(');
        this.appendParametersFromArgumentHolder(parameterTypes, methodSrc, argumentHolderGenerator);
        methodSrc.append(");\n}\n");
        return this.generateInvoker(ctClass, methodSrc);
    }

    private Invoker generateInvoker(CtClass ctClass, StringBuilder methodSrc) {
        try {
            ctClass.addMethod(CtMethod.make((String)methodSrc.toString(), (CtClass)ctClass));
            ctClass.addConstructor(CtNewConstructor.defaultConstructor((CtClass)ctClass));
            Class generatedClass = ctClass.toClass();
            return (Invoker)generatedClass.newInstance();
        }
        catch (CannotCompileException e) {
            throw new RuntimeException("Unable to compile generated source: " + methodSrc, e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to compile generated source: " + methodSrc, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to compile generated source: " + methodSrc, e);
        }
    }

    private <T> Map<Method, Invoker> createMethodToInvokerMap(Class<T> proxyInterface, ArgumentHolderGenerator argumentHolderGenerator) {
        Method[] declaredMethods;
        HashMap<Method, Invoker> methodToInvokerMap = new HashMap<Method, Invoker>();
        for (Method declaredMethod : declaredMethods = proxyInterface.getMethods()) {
            methodToInvokerMap.put(declaredMethod, this.generateInvoker(proxyInterface, declaredMethod, argumentHolderGenerator));
        }
        return methodToInvokerMap;
    }

    private void appendParametersFromArgumentHolder(Class<?>[] parameterTypes, StringBuilder methodSrc, ArgumentHolderGenerator argumentHolderGenerator) {
        argumentHolderGenerator.resetFieldNames();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            methodSrc.append("holder.").append(argumentHolderGenerator.getNextFieldNameForType(parameterType));
            if (i >= parameterTypes.length - 1) continue;
            methodSrc.append(", ");
        }
    }

    private static ClassPool configureClassPool() {
        ClassPool classPool = new ClassPool(ClassPool.getDefault());
        classPool.appendClassPath((ClassPath)new LoaderClassPath(Thread.currentThread().getContextClassLoader()));
        classPool.appendClassPath((ClassPath)new LoaderClassPath(ClassLoader.getSystemClassLoader()));
        classPool.importPackage("com.lmax.tool.disruptor");
        return classPool;
    }
}

