/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor.reflect;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.tool.disruptor.DropListener;
import com.lmax.tool.disruptor.Invoker;
import com.lmax.tool.disruptor.InvokerEventHandler;
import com.lmax.tool.disruptor.MessagePublicationListener;
import com.lmax.tool.disruptor.NoMessagePublicationListener;
import com.lmax.tool.disruptor.NoOpDropListener;
import com.lmax.tool.disruptor.OverflowStrategy;
import com.lmax.tool.disruptor.ProxyMethodInvocation;
import com.lmax.tool.disruptor.ResetHandler;
import com.lmax.tool.disruptor.RingBufferProxyGenerator;
import com.lmax.tool.disruptor.RingBufferProxyValidation;
import com.lmax.tool.disruptor.reflect.ObjectArrayHolder;
import com.lmax.tool.disruptor.reflect.ReflectiveMethodInvoker;
import com.lmax.tool.disruptor.reflect.RingBufferInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ReflectiveRingBufferProxyGenerator
implements RingBufferProxyGenerator {
    private final RingBufferProxyValidation validator;
    private final DropListener dropListener;
    private final MessagePublicationListener messagePublicationListener;

    public ReflectiveRingBufferProxyGenerator(RingBufferProxyValidation validator) {
        this(validator, NoOpDropListener.INSTANCE, NoMessagePublicationListener.INSTANCE);
    }

    public ReflectiveRingBufferProxyGenerator(RingBufferProxyValidation validator, DropListener dropListener) {
        this(validator, dropListener, NoMessagePublicationListener.INSTANCE);
    }

    public ReflectiveRingBufferProxyGenerator(RingBufferProxyValidation validator, DropListener dropListener, MessagePublicationListener messagePublicationListener) {
        this.validator = validator;
        this.dropListener = dropListener;
        this.messagePublicationListener = messagePublicationListener;
    }

    @Override
    public <T> T createRingBufferProxy(Class<T> proxyInterface, Disruptor<ProxyMethodInvocation> disruptor, OverflowStrategy overflowStrategy, T implementation) {
        this.validator.validateAll(disruptor, proxyInterface);
        RingBufferInvocationHandler invocationHandler = ReflectiveRingBufferProxyGenerator.createInvocationHandler(proxyInterface, disruptor, overflowStrategy, this.dropListener, this.messagePublicationListener);
        ReflectiveRingBufferProxyGenerator.preallocateArgumentHolders((RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer());
        disruptor.handleEventsWith(new EventHandler[]{new InvokerEventHandler<T>(implementation)});
        return ReflectiveRingBufferProxyGenerator.generateProxy(proxyInterface, invocationHandler);
    }

    @Override
    public <T> T createRingBufferProxy(Class<T> proxyInterface, Disruptor<ProxyMethodInvocation> disruptor, OverflowStrategy overflowStrategy, T ... implementations) {
        this.validator.validateAll(disruptor, proxyInterface);
        if (implementations.length < 1) {
            throw new IllegalArgumentException("Must have at least one implementation");
        }
        if (implementations.length == 1) {
            return this.createRingBufferProxy(proxyInterface, disruptor, overflowStrategy, implementations[0]);
        }
        RingBufferInvocationHandler invocationHandler = ReflectiveRingBufferProxyGenerator.createInvocationHandler(proxyInterface, disruptor, overflowStrategy, this.dropListener, this.messagePublicationListener);
        ReflectiveRingBufferProxyGenerator.preallocateArgumentHolders((RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer());
        EventHandler[] handlers = new InvokerEventHandler[implementations.length];
        for (int i = 0; i < implementations.length; ++i) {
            handlers[i] = new InvokerEventHandler<T>(implementations[i], false);
            disruptor.handleEventsWith(new EventHandler[]{handlers[i]});
        }
        disruptor.after(handlers).then(new EventHandler[]{new ResetHandler()});
        return ReflectiveRingBufferProxyGenerator.generateProxy(proxyInterface, invocationHandler);
    }

    private static <T> RingBufferInvocationHandler createInvocationHandler(Class<T> proxyInterface, Disruptor<ProxyMethodInvocation> disruptor, OverflowStrategy overflowStrategy, DropListener dropListener, MessagePublicationListener messagePublicationListener) {
        Map<Method, Invoker> methodToInvokerMap = ReflectiveRingBufferProxyGenerator.createMethodToInvokerMap(proxyInterface);
        return new RingBufferInvocationHandler((RingBuffer<ProxyMethodInvocation>)disruptor.getRingBuffer(), methodToInvokerMap, overflowStrategy, dropListener, messagePublicationListener);
    }

    private static <T> T generateProxy(Class<T> proxyInterface, RingBufferInvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{proxyInterface}, (InvocationHandler)invocationHandler);
    }

    private static void preallocateArgumentHolders(RingBuffer<ProxyMethodInvocation> ringBuffer) {
        int bufferSize = ringBuffer.getBufferSize();
        for (int i = 0; i < bufferSize; ++i) {
            ((ProxyMethodInvocation)ringBuffer.get((long)i)).setArgumentHolder(new ObjectArrayHolder());
        }
    }

    private static <T> Map<Method, Invoker> createMethodToInvokerMap(Class<T> proxyInterface) {
        Method[] declaredMethods;
        ConcurrentHashMap<Method, Invoker> methodToInvokerMap = new ConcurrentHashMap<Method, Invoker>();
        for (Method declaredMethod : declaredMethods = proxyInterface.getMethods()) {
            methodToInvokerMap.put(declaredMethod, new ReflectiveMethodInvoker(declaredMethod));
        }
        return methodToInvokerMap;
    }
}

