/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.tool.disruptor.reflect;

import com.lmax.disruptor.RingBuffer;
import com.lmax.tool.disruptor.DropListener;
import com.lmax.tool.disruptor.Invoker;
import com.lmax.tool.disruptor.MessagePublicationListener;
import com.lmax.tool.disruptor.OverflowStrategy;
import com.lmax.tool.disruptor.ProxyMethodInvocation;
import com.lmax.tool.disruptor.reflect.ObjectArrayHolder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;

final class RingBufferInvocationHandler
implements InvocationHandler {
    private final RingBuffer<ProxyMethodInvocation> ringBuffer;
    private final Map<Method, Invoker> methodToInvokerMap;
    private final OverflowStrategy overflowStrategy;
    private final DropListener dropListener;
    private final MessagePublicationListener messagePublicationListener;

    RingBufferInvocationHandler(RingBuffer<ProxyMethodInvocation> ringBuffer, Map<Method, Invoker> methodToInvokerMap, OverflowStrategy overflowStrategy, DropListener dropListener, MessagePublicationListener messagePublicationListener) {
        this.ringBuffer = ringBuffer;
        this.methodToInvokerMap = methodToInvokerMap;
        this.overflowStrategy = overflowStrategy;
        this.dropListener = dropListener;
        this.messagePublicationListener = messagePublicationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.messagePublicationListener.onPrePublish();
        if (this.overflowStrategy == OverflowStrategy.DROP && !this.ringBuffer.hasAvailableCapacity(1)) {
            this.dropListener.onDrop();
            return null;
        }
        long sequence = this.ringBuffer.next();
        try {
            ProxyMethodInvocation proxyMethodInvocation = (ProxyMethodInvocation)this.ringBuffer.get(sequence);
            ObjectArrayHolder argumentHolder = (ObjectArrayHolder)proxyMethodInvocation.getArgumentHolder();
            if (args != null) {
                Object[] copyOfArgs = new Object[args.length];
                System.arraycopy(args, 0, copyOfArgs, 0, args.length);
                argumentHolder.set(copyOfArgs);
            } else {
                argumentHolder.set(null);
            }
            proxyMethodInvocation.setInvoker(this.methodToInvokerMap.get(method));
        }
        finally {
            this.ringBuffer.publish(sequence);
            this.messagePublicationListener.onPostPublish();
        }
        return null;
    }
}

