/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.Sequencer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.PaddedLong;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

class SingleProducerSequencer
implements Sequencer {
    private final PaddedLong gatingSequenceCache = new PaddedLong(-1L);
    private long nextValue = -1L;
    private final WaitStrategy waitStrategy;
    private final int bufferSize;

    public SingleProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        this.bufferSize = bufferSize;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    long getNextValue() {
        return this.nextValue;
    }

    @Override
    public boolean hasAvailableCapacity(Sequence[] gatingSequences, int requiredCapacity) {
        long wrapPoint = this.nextValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.get();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > this.nextValue) {
            long minSequence = Util.getMinimumSequence(gatingSequences, this.nextValue);
            this.gatingSequenceCache.set(minSequence);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long next(Sequence[] gatingSequences) {
        long nextSequence = this.nextValue + 1L;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.gatingSequenceCache.get();
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > this.nextValue) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(gatingSequences, this.nextValue))) {
                LockSupport.parkNanos(1L);
            }
            this.gatingSequenceCache.set(minSequence);
        }
        this.nextValue = nextSequence;
        return nextSequence;
    }

    @Override
    public long tryNext(Sequence[] gatingSequences) throws InsufficientCapacityException {
        if (!this.hasAvailableCapacity(gatingSequences, 1)) {
            throw InsufficientCapacityException.INSTANCE;
        }
        long nextSequence = ++this.nextValue;
        return nextSequence;
    }

    @Override
    public long remainingCapacity(Sequence[] gatingSequences) {
        long consumed = Util.getMinimumSequence(gatingSequences, this.nextValue);
        long produced = this.nextValue;
        return (long)this.getBufferSize() - (produced - consumed);
    }

    @Override
    public void claim(long sequence) {
        this.nextValue = sequence;
    }

    @Override
    public long getCachedGatingSequence() {
        return this.gatingSequenceCache.get();
    }
}

