/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorThreeArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.EventTranslatorVararg;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.MultiProducerPublisher;
import com.lmax.disruptor.MultiProducerSequencer;
import com.lmax.disruptor.ProcessingSequenceBarrier;
import com.lmax.disruptor.Publisher;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.SequenceGroups;
import com.lmax.disruptor.Sequencer;
import com.lmax.disruptor.SingleProducerPublisher;
import com.lmax.disruptor.SingleProducerSequencer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public final class RingBuffer<E> {
    public static final long INITIAL_CURSOR_VALUE = -1L;
    private static final AtomicReferenceFieldUpdater<RingBuffer, Sequence[]> SEQUENCE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RingBuffer.class, Sequence[].class, "gatingSequences");
    private final int indexMask;
    private final Object[] entries;
    private final Sequence cursor;
    private final int bufferSize;
    private final Publisher publisher;
    private final Sequencer sequencer;
    private final WaitStrategy waitStrategy;
    protected volatile Sequence[] gatingSequences = new Sequence[0];

    private RingBuffer(EventFactory<E> eventFactory, Sequence cursor, Sequencer sequencer, Publisher publisher, WaitStrategy waitStrategy) {
        this.sequencer = sequencer;
        this.waitStrategy = waitStrategy;
        this.bufferSize = sequencer.getBufferSize();
        this.cursor = cursor;
        if (this.bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(this.bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.indexMask = this.bufferSize - 1;
        this.publisher = publisher;
        this.entries = new Object[sequencer.getBufferSize()];
        this.fill(eventFactory);
    }

    public static <E> RingBuffer<E> createMultiProducer(EventFactory<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        MultiProducerSequencer sequencer = new MultiProducerSequencer(bufferSize, waitStrategy);
        MultiProducerPublisher publisher = new MultiProducerPublisher(bufferSize, waitStrategy);
        RingBuffer<E> ringBuffer = new RingBuffer<E>(factory, sequencer.getCursorSequence(), sequencer, publisher, waitStrategy);
        return ringBuffer;
    }

    public static <E> RingBuffer<E> createMultiProducer(EventFactory<E> factory, int bufferSize) {
        return RingBuffer.createMultiProducer(factory, bufferSize, new BlockingWaitStrategy());
    }

    public static <E> RingBuffer<E> createSingleProducer(EventFactory<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        SingleProducerSequencer sequencer = new SingleProducerSequencer(bufferSize, waitStrategy);
        SingleProducerPublisher publisher = new SingleProducerPublisher(waitStrategy);
        RingBuffer<E> ringBuffer = new RingBuffer<E>(factory, publisher.getCursorSequence(), sequencer, publisher, waitStrategy);
        return ringBuffer;
    }

    public static <E> RingBuffer<E> createSingleProducer(EventFactory<E> factory, int bufferSize) {
        return RingBuffer.createSingleProducer(factory, bufferSize, new BlockingWaitStrategy());
    }

    public static <E> RingBuffer<E> create(ProducerType producerType, EventFactory<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        switch (producerType) {
            case SINGLE: {
                return RingBuffer.createSingleProducer(factory, bufferSize, waitStrategy);
            }
            case MULTI: {
                return RingBuffer.createMultiProducer(factory, bufferSize, waitStrategy);
            }
        }
        throw new IllegalStateException(producerType.toString());
    }

    public E getPublished(long sequence) {
        this.publisher.ensureAvailable(sequence);
        return (E)this.entries[(int)sequence & this.indexMask];
    }

    public long next() {
        return this.sequencer.next(this.gatingSequences);
    }

    public long tryNext() throws InsufficientCapacityException {
        return this.sequencer.tryNext(this.gatingSequences);
    }

    public void resetTo(long sequence) {
        this.sequencer.claim(sequence);
        this.publisher.publish(sequence);
    }

    public E claimAndGetPreallocated(long sequence) {
        this.sequencer.claim(sequence);
        return this.getPreallocated(sequence);
    }

    public boolean isPublished(long sequence) {
        return this.publisher.isAvailable(sequence);
    }

    public void addGatingSequences(Sequence ... gatingSequences) {
        SequenceGroups.addSequences(this, SEQUENCE_UPDATER, this, gatingSequences);
    }

    public long getMinimumGatingSequence() {
        return Util.getMinimumSequence(this.gatingSequences, this.cursor.get());
    }

    public boolean removeGatingSequence(Sequence sequence) {
        return SequenceGroups.removeSequence(this, SEQUENCE_UPDATER, sequence);
    }

    public SequenceBarrier newBarrier(Sequence ... sequencesToTrack) {
        return new ProcessingSequenceBarrier(this.waitStrategy, this.cursor, sequencesToTrack);
    }

    public final long getCursor() {
        return this.cursor.get();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.sequencer.hasAvailableCapacity(this.gatingSequences, requiredCapacity);
    }

    public void publishEvent(EventTranslator<E> translator) {
        long sequence = this.sequencer.next(this.gatingSequences);
        this.translateAndPublish(translator, sequence);
    }

    public boolean tryPublishEvent(EventTranslator<E> translator, int capacity) {
        try {
            long sequence = this.sequencer.tryNext(this.gatingSequences);
            this.translateAndPublish(translator, sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public <A> void publishEvent(EventTranslatorOneArg<E, A> translator, A arg0) {
        long sequence = this.sequencer.next(this.gatingSequences);
        this.translateAndPublish(translator, sequence, arg0);
    }

    public <A> boolean tryPublishEvent(EventTranslatorOneArg<E, A> translator, int capacity, A arg0) {
        try {
            long sequence = this.sequencer.tryNext(this.gatingSequences);
            this.translateAndPublish(translator, sequence, arg0);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public <A, B> void publishEvent(EventTranslatorTwoArg<E, A, B> translator, A arg0, B arg1) {
        long sequence = this.sequencer.next(this.gatingSequences);
        this.translateAndPublish(translator, sequence, arg0, arg1);
    }

    public <A, B> boolean tryPublishEvent(EventTranslatorTwoArg<E, A, B> translator, int capacity, A arg0, B arg1) {
        try {
            long sequence = this.sequencer.tryNext(this.gatingSequences);
            this.translateAndPublish(translator, sequence, arg0, arg1);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public <A, B, C> void publishEvent(EventTranslatorThreeArg<E, A, B, C> translator, A arg0, B arg1, C arg2) {
        long sequence = this.sequencer.next(this.gatingSequences);
        this.translateAndPublish(translator, sequence, arg0, arg1, arg2);
    }

    public <A, B, C> boolean tryPublishEvent(EventTranslatorThreeArg<E, A, B, C> translator, int capacity, A arg0, B arg1, C arg2) {
        try {
            long sequence = this.sequencer.tryNext(this.gatingSequences);
            this.translateAndPublish(translator, sequence, arg0, arg1, arg2);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public void publishEvent(EventTranslatorVararg<E> translator, Object ... args) {
        long sequence = this.sequencer.next(this.gatingSequences);
        this.translateAndPublish(translator, sequence, args);
    }

    public boolean tryPublishEvent(EventTranslatorVararg<E> translator, int capacity, Object ... args) {
        try {
            long sequence = this.sequencer.tryNext(this.gatingSequences);
            this.translateAndPublish(translator, sequence, args);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public E getPreallocated(long sequence) {
        return (E)this.entries[(int)sequence & this.indexMask];
    }

    public void publish(long sequence) {
        this.publisher.publish(sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateAndPublish(EventTranslator<E> translator, long sequence) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence);
        }
        finally {
            this.publisher.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> void translateAndPublish(EventTranslatorOneArg<E, A> translator, long sequence, A arg0) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, arg0);
        }
        finally {
            this.publisher.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A, B> void translateAndPublish(EventTranslatorTwoArg<E, A, B> translator, long sequence, A arg0, B arg1) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, arg0, arg1);
        }
        finally {
            this.publisher.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A, B, C> void translateAndPublish(EventTranslatorThreeArg<E, A, B, C> translator, long sequence, A arg0, B arg1, C arg2) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, arg0, arg1, arg2);
        }
        finally {
            this.publisher.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> void translateAndPublish(EventTranslatorVararg<E> translator, long sequence, Object ... args) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, args);
        }
        finally {
            this.publisher.publish(sequence);
        }
    }

    private void fill(EventFactory<E> eventFactory) {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = eventFactory.newInstance();
        }
    }

    long remainingCapacity() {
        return this.sequencer.remainingCapacity(this.gatingSequences);
    }
}

