/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.Cursored;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.EventTranslatorOneArg;
import com.lmax.disruptor.EventTranslatorThreeArg;
import com.lmax.disruptor.EventTranslatorTwoArg;
import com.lmax.disruptor.EventTranslatorVararg;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.MultiProducerSequencer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.Sequencer;
import com.lmax.disruptor.SingleProducerSequencer;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.ProducerType;

public final class RingBuffer<E>
implements Cursored {
    public static final long INITIAL_CURSOR_VALUE = -1L;
    private final int indexMask;
    private final Object[] entries;
    private final int bufferSize;
    private final Sequencer sequencer;

    private RingBuffer(EventFactory<E> eventFactory, Sequencer sequencer) {
        this.sequencer = sequencer;
        this.bufferSize = sequencer.getBufferSize();
        if (this.bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        if (Integer.bitCount(this.bufferSize) != 1) {
            throw new IllegalArgumentException("bufferSize must be a power of 2");
        }
        this.indexMask = this.bufferSize - 1;
        this.entries = new Object[sequencer.getBufferSize()];
        this.fill(eventFactory);
    }

    public static <E> RingBuffer<E> createMultiProducer(EventFactory<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        MultiProducerSequencer sequencer = new MultiProducerSequencer(bufferSize, waitStrategy);
        RingBuffer<E> ringBuffer = new RingBuffer<E>(factory, sequencer);
        return ringBuffer;
    }

    public static <E> RingBuffer<E> createMultiProducer(EventFactory<E> factory, int bufferSize) {
        return RingBuffer.createMultiProducer(factory, bufferSize, new BlockingWaitStrategy());
    }

    public static <E> RingBuffer<E> createSingleProducer(EventFactory<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        SingleProducerSequencer sequencer = new SingleProducerSequencer(bufferSize, waitStrategy);
        RingBuffer<E> ringBuffer = new RingBuffer<E>(factory, sequencer);
        return ringBuffer;
    }

    public static <E> RingBuffer<E> createSingleProducer(EventFactory<E> factory, int bufferSize) {
        return RingBuffer.createSingleProducer(factory, bufferSize, new BlockingWaitStrategy());
    }

    public static <E> RingBuffer<E> create(ProducerType producerType, EventFactory<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        switch (producerType) {
            case SINGLE: {
                return RingBuffer.createSingleProducer(factory, bufferSize, waitStrategy);
            }
            case MULTI: {
                return RingBuffer.createMultiProducer(factory, bufferSize, waitStrategy);
            }
        }
        throw new IllegalStateException(producerType.toString());
    }

    public E getPublished(long sequence) {
        this.sequencer.ensureAvailable(sequence);
        return (E)this.entries[(int)sequence & this.indexMask];
    }

    public long next() {
        return this.sequencer.next();
    }

    public long tryNext() throws InsufficientCapacityException {
        return this.sequencer.tryNext();
    }

    public void resetTo(long sequence) {
        this.sequencer.claim(sequence);
        this.sequencer.publish(sequence);
    }

    public E claimAndGetPreallocated(long sequence) {
        this.sequencer.claim(sequence);
        return this.getPreallocated(sequence);
    }

    public boolean isPublished(long sequence) {
        return this.sequencer.isAvailable(sequence);
    }

    public void addGatingSequences(Sequence ... gatingSequences) {
        this.sequencer.addGatingSequences(gatingSequences);
    }

    public long getMinimumGatingSequence() {
        return this.sequencer.getMinimumSequence();
    }

    public boolean removeGatingSequence(Sequence sequence) {
        return this.sequencer.removeSequence(sequence);
    }

    public SequenceBarrier newBarrier(Sequence ... sequencesToTrack) {
        return this.sequencer.newBarrier(sequencesToTrack);
    }

    @Override
    public final long getCursor() {
        return this.sequencer.getCursor();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.sequencer.hasAvailableCapacity(requiredCapacity);
    }

    public void publishEvent(EventTranslator<E> translator) {
        long sequence = this.sequencer.next();
        this.translateAndPublish(translator, sequence);
    }

    public boolean tryPublishEvent(EventTranslator<E> translator) {
        try {
            long sequence = this.sequencer.tryNext();
            this.translateAndPublish(translator, sequence);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public <A> void publishEvent(EventTranslatorOneArg<E, A> translator, A arg0) {
        long sequence = this.sequencer.next();
        this.translateAndPublish(translator, sequence, arg0);
    }

    public <A> boolean tryPublishEvent(EventTranslatorOneArg<E, A> translator, A arg0) {
        try {
            long sequence = this.sequencer.tryNext();
            this.translateAndPublish(translator, sequence, arg0);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public <A, B> void publishEvent(EventTranslatorTwoArg<E, A, B> translator, A arg0, B arg1) {
        long sequence = this.sequencer.next();
        this.translateAndPublish(translator, sequence, arg0, arg1);
    }

    public <A, B> boolean tryPublishEvent(EventTranslatorTwoArg<E, A, B> translator, A arg0, B arg1) {
        try {
            long sequence = this.sequencer.tryNext();
            this.translateAndPublish(translator, sequence, arg0, arg1);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public <A, B, C> void publishEvent(EventTranslatorThreeArg<E, A, B, C> translator, A arg0, B arg1, C arg2) {
        long sequence = this.sequencer.next();
        this.translateAndPublish(translator, sequence, arg0, arg1, arg2);
    }

    public <A, B, C> boolean tryPublishEvent(EventTranslatorThreeArg<E, A, B, C> translator, A arg0, B arg1, C arg2) {
        try {
            long sequence = this.sequencer.tryNext();
            this.translateAndPublish(translator, sequence, arg0, arg1, arg2);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public void publishEvent(EventTranslatorVararg<E> translator, Object ... args) {
        long sequence = this.sequencer.next();
        this.translateAndPublish(translator, sequence, args);
    }

    public boolean tryPublishEvent(EventTranslatorVararg<E> translator, Object ... args) {
        try {
            long sequence = this.sequencer.tryNext();
            this.translateAndPublish(translator, sequence, args);
            return true;
        }
        catch (InsufficientCapacityException e) {
            return false;
        }
    }

    public E getPreallocated(long sequence) {
        return (E)this.entries[(int)sequence & this.indexMask];
    }

    public void publish(long sequence) {
        this.sequencer.publish(sequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void translateAndPublish(EventTranslator<E> translator, long sequence) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence);
        }
        finally {
            this.sequencer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> void translateAndPublish(EventTranslatorOneArg<E, A> translator, long sequence, A arg0) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, arg0);
        }
        finally {
            this.sequencer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A, B> void translateAndPublish(EventTranslatorTwoArg<E, A, B> translator, long sequence, A arg0, B arg1) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, arg0, arg1);
        }
        finally {
            this.sequencer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A, B, C> void translateAndPublish(EventTranslatorThreeArg<E, A, B, C> translator, long sequence, A arg0, B arg1, C arg2) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, arg0, arg1, arg2);
        }
        finally {
            this.sequencer.publish(sequence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <A> void translateAndPublish(EventTranslatorVararg<E> translator, long sequence, Object ... args) {
        try {
            translator.translateTo(this.getPreallocated(sequence), sequence, args);
        }
        finally {
            this.sequencer.publish(sequence);
        }
    }

    private void fill(EventFactory<E> eventFactory) {
        for (int i = 0; i < this.entries.length; ++i) {
            this.entries[i] = eventFactory.newInstance();
        }
    }
}

