/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.AbstractSequencer;
import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

public final class SingleProducerSequencer
extends AbstractSequencer {
    private final Padding pad = new Padding();

    public SingleProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        super(bufferSize, waitStrategy);
    }

    long getNextValue() {
        return this.pad.nextValue;
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        long nextValue = this.pad.nextValue;
        long wrapPoint = nextValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.pad.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            this.pad.cachedValue = minSequence = Util.getMinimumSequence(this.gatingSequences, nextValue);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long next() {
        long nextValue = this.pad.nextValue;
        long nextSequence = nextValue + 1L;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.pad.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            while (wrapPoint > (minSequence = Util.getMinimumSequence(this.gatingSequences, nextValue))) {
                LockSupport.parkNanos(1L);
            }
            this.pad.cachedValue = minSequence;
        }
        this.pad.nextValue = nextSequence;
        return nextSequence;
    }

    @Override
    public long tryNext() throws InsufficientCapacityException {
        if (!this.hasAvailableCapacity(1)) {
            throw InsufficientCapacityException.INSTANCE;
        }
        long nextSequence = ++this.pad.nextValue;
        return nextSequence;
    }

    @Override
    public long remainingCapacity(Sequence[] gatingSequences) {
        long nextValue = this.pad.nextValue;
        long consumed = Util.getMinimumSequence(gatingSequences, nextValue);
        long produced = nextValue;
        return (long)this.getBufferSize() - (produced - consumed);
    }

    @Override
    public void claim(long sequence) {
        this.pad.nextValue = sequence;
    }

    @Override
    public void publish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void ensureAvailable(long sequence) {
    }

    @Override
    public boolean isAvailable(long sequence) {
        return sequence <= this.cursor.get();
    }

    Sequence getCursorSequence() {
        return this.cursor;
    }

    private static class Padding {
        public long nextValue = -1L;
        public long cachedValue = -1L;
        public long p2;
        public long p3;
        public long p4;
        public long p5;
        public long p6;
        public long p7;

        private Padding() {
        }
    }
}

