/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.disruptor;

import com.lmax.disruptor.InsufficientCapacityException;
import com.lmax.disruptor.SingleProducerSequencerFields;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.util.Util;
import java.util.Arrays;
import java.util.concurrent.locks.LockSupport;

public final class SingleProducerSequencer
extends SingleProducerSequencerFields {
    protected byte p10;
    protected byte p11;
    protected byte p12;
    protected byte p13;
    protected byte p14;
    protected byte p15;
    protected byte p16;
    protected byte p17;
    protected byte p20;
    protected byte p21;
    protected byte p22;
    protected byte p23;
    protected byte p24;
    protected byte p25;
    protected byte p26;
    protected byte p27;
    protected byte p30;
    protected byte p31;
    protected byte p32;
    protected byte p33;
    protected byte p34;
    protected byte p35;
    protected byte p36;
    protected byte p37;
    protected byte p40;
    protected byte p41;
    protected byte p42;
    protected byte p43;
    protected byte p44;
    protected byte p45;
    protected byte p46;
    protected byte p47;
    protected byte p50;
    protected byte p51;
    protected byte p52;
    protected byte p53;
    protected byte p54;
    protected byte p55;
    protected byte p56;
    protected byte p57;
    protected byte p60;
    protected byte p61;
    protected byte p62;
    protected byte p63;
    protected byte p64;
    protected byte p65;
    protected byte p66;
    protected byte p67;
    protected byte p70;
    protected byte p71;
    protected byte p72;
    protected byte p73;
    protected byte p74;
    protected byte p75;
    protected byte p76;
    protected byte p77;

    public SingleProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        super(bufferSize, waitStrategy);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.hasAvailableCapacity(requiredCapacity, false);
    }

    private boolean hasAvailableCapacity(int requiredCapacity, boolean doStore) {
        long nextValue = this.nextValue;
        long wrapPoint = nextValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            if (doStore) {
                this.cursor.setVolatile(nextValue);
            }
            this.cachedValue = minSequence = Util.getMinimumSequence(this.gatingSequences, nextValue);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long next() {
        return this.next(1);
    }

    @Override
    public long next(int n) {
        if (n < 1 || n > this.bufferSize) {
            throw new IllegalArgumentException("n must be > 0 and < bufferSize");
        }
        long nextValue = this.nextValue;
        long nextSequence = nextValue + (long)n;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            this.cursor.setVolatile(nextValue);
            while (wrapPoint > (minSequence = Util.getMinimumSequence(this.gatingSequences, nextValue))) {
                LockSupport.parkNanos(1L);
            }
            this.cachedValue = minSequence;
        }
        this.nextValue = nextSequence;
        return nextSequence;
    }

    @Override
    public long tryNext() throws InsufficientCapacityException {
        return this.tryNext(1);
    }

    @Override
    public long tryNext(int n) throws InsufficientCapacityException {
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if (!this.hasAvailableCapacity(n, true)) {
            throw InsufficientCapacityException.INSTANCE;
        }
        long nextSequence = this.nextValue += (long)n;
        return nextSequence;
    }

    @Override
    public long remainingCapacity() {
        long nextValue = this.nextValue;
        long consumed = Util.getMinimumSequence(this.gatingSequences, nextValue);
        long produced = nextValue;
        return (long)this.getBufferSize() - (produced - consumed);
    }

    @Override
    public void claim(long sequence) {
        this.nextValue = sequence;
    }

    @Override
    public void publish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        this.publish(hi);
    }

    @Override
    public boolean isAvailable(long sequence) {
        long currentSequence = this.cursor.get();
        return sequence <= currentSequence && sequence > currentSequence - (long)this.bufferSize;
    }

    @Override
    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        return availableSequence;
    }

    @Override
    public String toString() {
        return "SingleProducerSequencer{bufferSize=" + this.bufferSize + ", waitStrategy=" + this.waitStrategy + ", cursor=" + this.cursor + ", gatingSequences=" + Arrays.toString(this.gatingSequences) + "}";
    }
}

