/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.simpledsl.api;

import com.lmax.simpledsl.api.DslArg;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface DslValues {
    public boolean hasValue(String var1);

    public boolean hasParam(String var1);

    public String value(String var1);

    public String[] values(String var1);

    default public boolean hasParamAndValue(String name) {
        return this.hasParam(name) && this.hasValue(name);
    }

    default public <T> T valueAs(String name, Function<String, T> mapper) {
        String value = this.value(name);
        return value != null ? (T)mapper.apply(value) : null;
    }

    default public <T extends Enum<T>> T valueAs(String name, Class<T> enumType) {
        return (T)this.valueAs(name, (String val) -> Enum.valueOf(enumType, val));
    }

    default public <T> Object[] valuesAs(String name, Function<String, T> mapper) {
        return Arrays.stream(this.values(name)).map(mapper).toArray();
    }

    default public <T> T[] valuesAs(String name, Class<T> type, Function<String, T> mapper) {
        return Arrays.stream(this.values(name)).map(mapper).toArray(n -> (Object[])Array.newInstance(type, n));
    }

    default public <T extends Enum<T>> T[] valuesAs(String name, Class<T> enumType) {
        return this.valuesAs(name, enumType, val -> Enum.valueOf(enumType, val));
    }

    default public Optional<String> valueAsOptional(String name) {
        return Optional.ofNullable(this.value(name));
    }

    default public <T> Optional<T> valueAsOptionalOf(String name, Function<String, T> mapper) {
        return Optional.ofNullable(this.value(name)).map(mapper);
    }

    default public boolean valueAsBoolean(String name) {
        return this.valueAs(name, Boolean::parseBoolean);
    }

    default public int valueAsInt(String name) {
        return this.valueAs(name, Integer::parseInt);
    }

    default public long valueAsLong(String name) {
        return this.valueAs(name, Long::parseLong);
    }

    default public double valueAsDouble(String name) {
        return this.valueAs(name, Double::parseDouble);
    }

    default public BigDecimal valueAsBigDecimal(String name) {
        return this.valueAs(name, BigDecimal::new);
    }

    default public String valueAsParam(String name) {
        String value = this.value(name);
        return value != null ? name + ": " + value : null;
    }

    default public String valueAsParamNamed(String oldParamName, String newParamName) {
        String value = this.value(oldParamName);
        return value != null ? newParamName + ": " + value : null;
    }

    default public List<String> valuesAsList(String name) {
        return Arrays.asList(this.values(name));
    }

    default public <T> List<T> valuesAsListOf(String name, Function<String, T> mapper) {
        return Arrays.stream(this.values(name)).map(mapper).collect(Collectors.toList());
    }

    default public Optional<List<String>> valuesAsOptional(String name) {
        return Optional.of(this.valuesAsList(name)).filter(list -> !list.isEmpty());
    }

    default public OptionalInt valuesAsOptionalInt(String name) {
        return this.hasValue(name) ? OptionalInt.of(this.valueAsInt(name)) : OptionalInt.empty();
    }

    default public OptionalLong valuesAsOptionalLong(String name) {
        return this.hasValue(name) ? OptionalLong.of(this.valueAsLong(name)) : OptionalLong.empty();
    }

    default public OptionalDouble valuesAsOptionalDouble(String name) {
        return this.hasValue(name) ? OptionalDouble.of(this.valueAsInt(name)) : OptionalDouble.empty();
    }

    default public int[] valuesAsInts(String name) {
        return Arrays.stream(this.values(name)).mapToInt(Integer::parseInt).toArray();
    }

    default public long[] valuesAsLongs(String name) {
        return Arrays.stream(this.values(name)).mapToLong(Long::parseLong).toArray();
    }

    default public double[] valuesAsDoubles(String name) {
        return Arrays.stream(this.values(name)).mapToDouble(Double::parseDouble).toArray();
    }

    default public BigDecimal[] valuesAsBigDecimals(String name) {
        return this.valuesAs(name, BigDecimal.class, BigDecimal::new);
    }

    public DslArg[] getParams();
}

