/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.simpledsl.api;

import com.lmax.simpledsl.api.DslArg;
import java.util.Arrays;

public abstract class SimpleDslArg
implements DslArg {
    private static final String DEFAULT_DELIMITER = ",";
    private final String name;
    private final boolean required;
    protected String defaultValue;
    protected boolean allowMultipleValues;
    protected String multipleValueSeparator;
    protected String[] allowedValues;

    public SimpleDslArg(String name, boolean required) {
        this.name = name;
        this.required = required;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getDefaultValue() {
        if (this.required) {
            throw new IllegalArgumentException("A required argument can not have a default value");
        }
        return this.defaultValue;
    }

    @Override
    public boolean isAllowMultipleValues() {
        return this.allowMultipleValues;
    }

    @Override
    public String getMultipleValueSeparator() {
        return this.multipleValueSeparator;
    }

    @Override
    public String[] getAllowedValues() {
        return this.allowedValues;
    }

    public SimpleDslArg setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public SimpleDslArg setAllowedValues(String ... allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }

    public <T> SimpleDslArg setAllowedValues(Class<T> clazz) {
        if (Boolean.class.isAssignableFrom(clazz)) {
            return this.setAllowedValues("true", "false");
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.setAllowedValues((String[])Arrays.stream(clazz.getEnumConstants()).map(constant -> (Enum)constant).map(Enum::name).toArray(String[]::new));
        }
        throw new IllegalArgumentException("Cannot assign allowed values from class " + clazz.getName());
    }

    public SimpleDslArg setAllowMultipleValues() {
        return this.setAllowMultipleValues(DEFAULT_DELIMITER);
    }

    public SimpleDslArg setAllowMultipleValues(String delimiter) {
        this.allowMultipleValues = true;
        this.multipleValueSeparator = delimiter;
        return this;
    }
}

