/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.simpledsl.internal;

import com.lmax.simpledsl.api.DslArg;
import com.lmax.simpledsl.api.DslParams;
import com.lmax.simpledsl.api.RepeatingGroup;
import com.lmax.simpledsl.internal.DslParam;
import com.lmax.simpledsl.internal.RepeatingParamGroup;
import java.util.Map;
import java.util.Optional;

final class DslParamsImpl
implements DslParams {
    private final DslArg[] args;
    private final Map<String, DslParam> paramsByName;

    DslParamsImpl(DslArg[] args, Map<String, DslParam> paramsByName) {
        this.args = args;
        this.paramsByName = paramsByName;
    }

    @Override
    public String value(String name) {
        DslParam param = this.getDslParam(name);
        return param.getAsSimpleDslParam().getValue();
    }

    @Override
    public String[] values(String name) {
        DslParam param = this.getDslParam(name);
        return param.getAsSimpleDslParam().getValues();
    }

    @Override
    public RepeatingGroup[] valuesAsGroup(String groupName) {
        DslParam param = this.getDslParam(groupName);
        RepeatingParamGroup repeatingParamGroup = param.asRepeatingParamGroup();
        return repeatingParamGroup.values();
    }

    @Override
    public boolean hasValue(String name) {
        return this.findDslParam(name).map(DslParam::hasValue).orElse(false);
    }

    @Override
    public boolean hasParam(String name) {
        return this.findDslParam(name).isPresent();
    }

    @Override
    public DslArg[] getParams() {
        return this.args;
    }

    private DslParam getDslParam(String name) {
        return this.findDslParam(name).orElseThrow(() -> new IllegalArgumentException(name + " is not a parameter"));
    }

    private Optional<DslParam> findDslParam(String name) {
        return Optional.ofNullable(name).map(String::toLowerCase).map(this.paramsByName::get);
    }
}

