/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.simpledsl.internal;

import com.lmax.simpledsl.api.DslArg;
import com.lmax.simpledsl.api.DslParams;
import com.lmax.simpledsl.api.RepeatingArgGroup;
import com.lmax.simpledsl.api.SimpleDslArg;
import com.lmax.simpledsl.internal.DslParam;
import com.lmax.simpledsl.internal.DslParamsImpl;
import com.lmax.simpledsl.internal.NameValuePair;
import com.lmax.simpledsl.internal.RepeatingParamGroup;
import com.lmax.simpledsl.internal.RepeatingParamValues;
import com.lmax.simpledsl.internal.SimpleDslParam;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DslParamsParser {
    public DslParams parse(String[] args, DslArg ... dslArgs) {
        Deque<NameValuePair> arguments = DslParamsParser.parseArgumentValues(args);
        ArgumentProcessor argumentProcessor = new ArgumentProcessor();
        argumentProcessor.drain(dslArgs, arguments);
        Map<String, DslParam> paramsByName = argumentProcessor.collect(dslArgs);
        return new DslParamsImpl(dslArgs, paramsByName);
    }

    private static Deque<NameValuePair> parseArgumentValues(String[] args) {
        ArrayDeque<NameValuePair> nameValuePairs = new ArrayDeque<NameValuePair>();
        for (String arg : args) {
            NameValuePair nameValuePair = NameValuePair.fromArgumentString(arg);
            nameValuePairs.add(nameValuePair);
        }
        return nameValuePairs;
    }

    private static String checkValidValue(DslArg arg, String value) {
        if (arg.getAllowedValues() != null) {
            for (String allowedValue : arg.getAllowedValues()) {
                if (!allowedValue.equalsIgnoreCase(value)) continue;
                return allowedValue;
            }
            throw new IllegalArgumentException(arg.getName() + " parameter value '" + value + "' must be one of: " + Arrays.toString(arg.getAllowedValues()));
        }
        return value;
    }

    private static final class RepeatingGroupArgumentProcessor {
        final Map<DslArg, List<RepeatingParamValues>> groupsByArg;

        RepeatingGroupArgumentProcessor(Map<DslArg, List<RepeatingParamValues>> groupsByArg) {
            this.groupsByArg = groupsByArg;
        }

        void consume(RepeatingArgGroup groupArg, Deque<NameValuePair> arguments) {
            HashMap<DslArg, List<String>> valuesByArg = new HashMap<DslArg, List<String>>();
            SimpleArgumentProcessor processor = new SimpleArgumentProcessor(valuesByArg, "Did not supply a value for %s in group " + groupArg.getName());
            processor.consume(groupArg.getIdentity(), arguments);
            HashMap<String, SimpleDslArg> argsByName = new HashMap<String, SimpleDslArg>();
            argsByName.put(groupArg.getIdentity().getName(), groupArg.getIdentity());
            for (SimpleDslArg dslArg : groupArg.getOtherArgs()) {
                if (argsByName.put(dslArg.getName().toLowerCase(), dslArg) == null) continue;
                throw new IllegalArgumentException("Duplicate parameter '" + dslArg.getName() + "' in group " + groupArg.getName());
            }
            while (!arguments.isEmpty()) {
                List argValues;
                NameValuePair argument = arguments.peekFirst();
                if (argument == NameValuePair.NULL) {
                    arguments.pollFirst();
                    continue;
                }
                if (argument.name == null) {
                    throw new IllegalArgumentException("Unexpected ambiguous argument " + argument.originalValue);
                }
                DslArg arg = (DslArg)argsByName.get(argument.name.toLowerCase());
                if (arg == null || !(argValues = valuesByArg.computeIfAbsent(arg, k -> new ArrayList())).isEmpty() && !arg.isAllowMultipleValues()) break;
                SimpleArgumentProcessor.addValue(arg, argument.value, argValues);
                arguments.pollFirst();
            }
            HashMap<String, List<String>> valuesByName = new HashMap<String, List<String>>();
            for (SimpleDslArg simpleDslArg : argsByName.values()) {
                SimpleDslParam param = processor.collect(simpleDslArg);
                if (!param.hasValue()) continue;
                valuesByName.put(param.getName().toLowerCase(), param.getValuesAsList());
            }
            DslArg[] dslArgs = new DslArg[groupArg.getOtherArgs().length + 1];
            dslArgs[0] = groupArg.getIdentity();
            System.arraycopy(groupArg.getOtherArgs(), 0, dslArgs, 1, groupArg.getOtherArgs().length);
            this.groupsByArg.computeIfAbsent(groupArg, k -> new ArrayList()).add(new RepeatingParamValues(dslArgs, valuesByName));
        }

        RepeatingParamGroup collect(RepeatingArgGroup arg) {
            return new RepeatingParamGroup(arg.getName(), this.groupsByArg.getOrDefault(arg, Collections.emptyList()));
        }
    }

    private static final class SimpleArgumentProcessor {
        private final Map<DslArg, List<String>> valuesByArg;
        private final String requiredParamMissingError;

        SimpleArgumentProcessor(Map<DslArg, List<String>> valuesByArg, String requiredParamMissingError) {
            this.valuesByArg = valuesByArg;
            this.requiredParamMissingError = requiredParamMissingError;
        }

        void consume(DslArg arg, Deque<NameValuePair> args) {
            List values = this.valuesByArg.computeIfAbsent(arg, k -> new ArrayList());
            while (SimpleArgumentProcessor.consumeSingleParam(arg, args, values) && arg.isAllowMultipleValues()) {
            }
        }

        SimpleDslParam collect(SimpleDslArg arg) {
            List<String> values = this.valuesByArg.getOrDefault(arg, Collections.emptyList());
            List<String> validatedValues = this.validateSimpleArg(arg, values);
            return new SimpleDslParam(arg.getName(), validatedValues);
        }

        private static boolean consumeSingleParam(DslArg arg, Deque<NameValuePair> args, List<String> values) {
            NameValuePair nameValue;
            if (!args.isEmpty() && SimpleArgumentProcessor.matches(arg, nameValue = args.peekFirst())) {
                SimpleArgumentProcessor.addValue(arg, nameValue.value, values);
                args.pollFirst();
                return true;
            }
            return false;
        }

        private static boolean matches(DslArg arg, NameValuePair value) {
            return value != NameValuePair.NULL && (value.name == null || arg.getName().equalsIgnoreCase(value.name));
        }

        private static void addValue(DslArg arg, String value, List<String> values) {
            if (arg.isAllowMultipleValues()) {
                String[] vals;
                for (String singleValue : vals = value.split(Pattern.quote(arg.getMultipleValueSeparator()))) {
                    SimpleArgumentProcessor.addSingleValue(arg, singleValue.trim(), values);
                }
            } else {
                SimpleArgumentProcessor.addSingleValue(arg, value, values);
            }
        }

        private static void addSingleValue(DslArg arg, String value, List<String> values) {
            SimpleArgumentProcessor.checkCanAddValue(arg, values);
            values.add(DslParamsParser.checkValidValue(arg, value));
        }

        private static void checkCanAddValue(DslArg arg, List<String> values) {
            if (!arg.isAllowMultipleValues() && values.size() == 1) {
                throw new IllegalArgumentException("Multiple " + arg.getName() + " parameters are not allowed");
            }
        }

        private List<String> validateSimpleArg(SimpleDslArg arg, List<String> values) {
            if (values.isEmpty()) {
                if (arg.isRequired()) {
                    throw new IllegalArgumentException(String.format(this.requiredParamMissingError, arg.getName()));
                }
                return arg.getDefaultValue() == null ? Collections.emptyList() : Collections.singletonList(arg.getDefaultValue());
            }
            return values;
        }
    }

    private static final class ArgumentProcessor {
        private final SimpleArgumentProcessor simpleProcessor = new SimpleArgumentProcessor(new HashMap<DslArg, List<String>>(), "Missing value for parameter: %s");
        private final RepeatingGroupArgumentProcessor groupProcessor = new RepeatingGroupArgumentProcessor(new HashMap<DslArg, List<RepeatingParamValues>>());

        private ArgumentProcessor() {
        }

        void drain(DslArg[] args, Deque<NameValuePair> arguments) {
            for (DslArg arg : args) {
                NameValuePair argument = arguments.peekFirst();
                if (argument == null) continue;
                if (argument == NameValuePair.NULL) {
                    arguments.pollFirst();
                    continue;
                }
                if (this.invalidNamedParameter(arg, argument)) break;
                this.consume(arg, arguments);
            }
            HashMap<String, DslArg> argsByName = new HashMap<String, DslArg>();
            for (DslArg dslArg : args) {
                if (argsByName.put(dslArg.getName().toLowerCase(), dslArg) == null) continue;
                throw new IllegalArgumentException("Duplicate parameter '" + dslArg.getName() + "'");
            }
            while (!arguments.isEmpty()) {
                NameValuePair argument = arguments.peekFirst();
                if (argument == NameValuePair.NULL) {
                    arguments.pollFirst();
                    continue;
                }
                if (argument.name == null) {
                    throw new IllegalArgumentException("Unexpected ambiguous argument " + argument.originalValue);
                }
                DslArg arg = (DslArg)argsByName.get(argument.name.toLowerCase());
                if (arg == null) {
                    throw new IllegalArgumentException("Unexpected argument " + argument.originalValue);
                }
                this.consume(arg, arguments);
            }
        }

        Map<String, DslParam> collect(DslArg[] args) {
            HashMap<String, DslParam> map = new HashMap<String, DslParam>();
            for (DslArg dslArg : args) {
                DslParam val = dslArg instanceof RepeatingArgGroup ? this.groupProcessor.collect((RepeatingArgGroup)dslArg) : this.simpleProcessor.collect((SimpleDslArg)dslArg);
                map.put(dslArg.getName().toLowerCase(), val);
            }
            return map;
        }

        private void consume(DslArg arg, Deque<NameValuePair> arguments) {
            if (arg instanceof RepeatingArgGroup) {
                this.groupProcessor.consume((RepeatingArgGroup)arg, arguments);
            } else {
                this.simpleProcessor.consume(arg, arguments);
            }
        }

        private boolean invalidNamedParameter(DslArg arg, NameValuePair argument) {
            return argument.name != null && (arg.isRequired() && !arg.getName().equals(argument.name) || !arg.isRequired());
        }
    }
}

