/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.simpledsl.internal;

import com.lmax.simpledsl.api.DslArg;
import com.lmax.simpledsl.api.RepeatingGroup;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class RepeatingParamValues
implements RepeatingGroup {
    private final DslArg[] dslArgs;
    private final Map<String, List<String>> valuesByName;

    RepeatingParamValues(DslArg[] dslArgs, Map<String, List<String>> valuesByName) {
        this.dslArgs = dslArgs;
        this.valuesByName = valuesByName;
    }

    @Override
    public boolean hasValue(String name) {
        return this.valuesByName.containsKey(name.toLowerCase());
    }

    @Override
    public boolean hasParam(String name) {
        return Arrays.stream(this.dslArgs).anyMatch(arg -> arg.getName().equalsIgnoreCase(name));
    }

    @Override
    public String value(String name) {
        String[] strings = this.values(name);
        return strings.length > 0 ? strings[0] : null;
    }

    @Override
    public String[] values(String name) {
        List<String> values = this.getValues(name);
        return values != null ? values.toArray(new String[0]) : new String[]{};
    }

    @Override
    public DslArg[] getParams() {
        return this.dslArgs;
    }

    private List<String> getValues(String name) {
        return name != null ? this.valuesByName.get(name.toLowerCase()) : null;
    }
}

