/*
 * Decompiled with CFR 0.152.
 */
package com.lmax.simpledsl.internal;

import com.lmax.simpledsl.internal.DslParam;
import com.lmax.simpledsl.internal.RepeatingParamGroup;
import java.util.Collections;
import java.util.List;

class SimpleDslParam
extends DslParam {
    private final String name;
    private final List<String> values;

    SimpleDslParam(String name, List<String> values) {
        this.name = name;
        this.values = values;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    SimpleDslParam getAsSimpleDslParam() {
        return this;
    }

    @Override
    RepeatingParamGroup asRepeatingParamGroup() {
        throw new IllegalArgumentException(this.name + " is not a repeating group");
    }

    @Override
    boolean hasValue() {
        return !this.values.isEmpty();
    }

    public String getValue() {
        if (this.values.size() > 1) {
            throw new IllegalArgumentException("getValues() should be used when multiple values are allowed");
        }
        String[] strings = this.getValues();
        return strings.length > 0 ? strings[0] : null;
    }

    List<String> getValuesAsList() {
        return Collections.unmodifiableList(this.values);
    }

    String[] getValues() {
        return this.getValuesAsList().toArray(new String[0]);
    }
}

