/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.app.common.utils;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public final class CoreUtils {
    private static final Pattern UPPERCASE_PATTERN = Pattern.compile("[A-Z]");

    public static String getUuid() {
        UUID object = UUID.randomUUID();
        String uuid = object.toString();
        uuid = uuid.replaceAll("-", "");
        return uuid;
    }

    public static String getRandomNumber(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(str.length());
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String getRandomNumberForNumbers(int length) {
        String str = "0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(str.length());
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static String humpNameToUnderline(String humpName) {
        Matcher matcher = UPPERCASE_PATTERN.matcher(humpName);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getMaxLengthString(String param, int length) {
        Objects.requireNonNull(param, "The intercepted string cannot be empty");
        if (param.length() > length) {
            return param.substring(0, length - 3) + "...";
        }
        return param;
    }

    public static String hideString(String param, int start, int end) {
        if (StringUtils.isBlank((CharSequence)param)) {
            return param;
        }
        if (param.length() <= start + end) {
            return param;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = start; i < param.length() - end; ++i) {
            stringBuilder.append("*");
        }
        return param.substring(0, start) + stringBuilder.toString() + param.substring(param.length() - end);
    }

    public static String digitUppercase(long param) {
        BigDecimal amount = new BigDecimal(param).divide(new BigDecimal("100"), 2, 4);
        String[] fraction = new String[]{"\u89d2", "\u5206"};
        String[] digit = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
        String[][] unit = new String[][]{{"\u5143", "\u4e07", "\u4ebf"}, {"", "\u62fe", "\u4f70", "\u4edf"}};
        String head = amount.doubleValue() < 0.0 ? "\u8d1f" : "";
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < fraction.length; ++i) {
            double f1 = amount.multiply(BigDecimal.valueOf(10.0 * Math.pow(10.0, i))).doubleValue();
            s.append((digit[(int)(Math.floor(f1) % 10.0)] + fraction[i]).replaceAll("(\u96f6.)+", ""));
        }
        if (s.length() < 1) {
            s = new StringBuilder("\u6574");
        }
        int integerPart = (int)Math.floor(amount.doubleValue());
        for (int i = 0; i < unit[0].length && integerPart > 0; ++i) {
            String p = "";
            for (int j = 0; j < unit[1].length && amount.doubleValue() > 0.0; ++j) {
                p = digit[integerPart % 10] + unit[1][j] + p;
                integerPart /= 10;
            }
            s.insert(0, p.replaceAll("(\u96f6.)*\u96f6$", "").replaceAll("^$", "\u96f6") + unit[0][i]);
        }
        return head + s.toString().replaceAll("(\u96f6.)*\u96f6\u5143", "\u5143").replaceFirst("(\u96f6.)+", "").replaceAll("(\u96f6.)+", "\u96f6").replaceAll("^\u6574$", "\u96f6\u5143\u6574");
    }

    public static String getMapValue(String key, Map<String, Object> map) {
        if (Objects.isNull(map)) {
            return "";
        }
        Object mapValue = map.get(key);
        if (!Objects.isNull(mapValue)) {
            return mapValue.toString();
        }
        return "";
    }

    public static long getDataCenterId() {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                    id %= 32L;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static String byteToStr(byte[] buffer) {
        try {
            int length = 0;
            for (int i = 0; i < buffer.length; ++i) {
                if (buffer[i] != 0) continue;
                length = i;
                break;
            }
            return new String(buffer, 0, length, "GBK");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getCRC(byte[] bytes) {
        int crc = 0;
        int polynomial = 4129;
        for (byte b : bytes) {
            for (int i = 0; i < 8; ++i) {
                boolean bit = (b >> 7 - i & 1) == 1;
                boolean c15 = (crc >> 15 & 1) == 1;
                crc <<= 1;
                if (!(c15 ^ bit)) continue;
                crc ^= polynomial;
            }
        }
        return String.format("%04x", crc &= 0xFFFF);
    }

    public static String longToHex(long number) {
        return String.format("%016x", number);
    }

    public static Date localToUtc(Date localDate) {
        long localTimeInMillis = localDate.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(localTimeInMillis);
        int zoneOffset = calendar.get(15);
        int dstOffset = calendar.get(16);
        calendar.add(14, -(zoneOffset + dstOffset));
        return new Date(calendar.getTimeInMillis());
    }

    public static String byteTobit(byte b) {
        return String.valueOf(b >> 7 & 1) + (b >> 6 & 1) + (b >> 5 & 1) + (b >> 4 & 1) + (b >> 3 & 1) + (b >> 2 & 1) + (b >> 1 & 1) + (b & 1);
    }

    public static byte bitToByte(String bit) {
        if (null == bit) {
            return 0;
        }
        int len = bit.length();
        if (len != 4 && len != 8) {
            return 0;
        }
        int re = len == 8 ? (bit.charAt(0) == '0' ? Integer.parseInt(bit, 2) : Integer.parseInt(bit, 2) - 256) : Integer.parseInt(bit, 2);
        return (byte)re;
    }

    public static byte[] intToBytes(int num) {
        byte[] bytes = new byte[]{(byte)(num >>> 24), (byte)(num >>> 16), (byte)(num >>> 8), (byte)num};
        return bytes;
    }

    public static int bytesToInt(byte[] bytes) {
        int int1 = bytes[0] & 0xFF;
        int int2 = (bytes[1] & 0xFF) << 8;
        int int3 = (bytes[2] & 0xFF) << 16;
        int int4 = (bytes[3] & 0xFF) << 24;
        return int1 | int2 | int3 | int4;
    }

    private CoreUtils() {
    }
}

