/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.app.common.utils;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class DateUtils {
    public static final String TIME_START_POSTFIX = "00:00:00.000";
    public static final String TIME_END_POSTFIX = "23:59:59.999";
    private static final String[] ZODIAC_ARR = new String[]{"\u7334", "\u9e21", "\u72d7", "\u732a", "\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a"};
    private static final String[] CONSTELLATION_ARR = new String[]{"\u6c34\u74f6\u5ea7", "\u53cc\u9c7c\u5ea7", "\u767d\u7f8a\u5ea7", "\u91d1\u725b\u5ea7", "\u53cc\u5b50\u5ea7", "\u5de8\u87f9\u5ea7", "\u72ee\u5b50\u5ea7", "\u5904\u5973\u5ea7", "\u5929\u79e4\u5ea7", "\u5929\u874e\u5ea7", "\u5c04\u624b\u5ea7", "\u9b54\u7faf\u5ea7"};
    private static final int[] CONSTELLATION_EDGE_DAY = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
    public static String YEAR_REGEX = "^\\d{4}$";
    public static String MONTH_REGEX = "^\\d{4}([-/.])\\d{1,2}$";
    public static String DATE_REGEX = "^\\d{4}([-/.])\\d{1,2}\\1\\d{1,2}$";

    public static String getZodica(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return ZODIAC_ARR[cal.get(1) % 12];
    }

    public static String getConstellation(Date date) {
        Objects.requireNonNull(date, "\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        int day = cal.get(5);
        if (day < CONSTELLATION_EDGE_DAY[month]) {
            --month;
        }
        if (month >= 0) {
            return CONSTELLATION_ARR[month];
        }
        return CONSTELLATION_ARR[11];
    }

    public static Date getDayBegin() {
        Date date = new Date();
        return DateUtils.getDayStartTime(date);
    }

    public static Date getDayEnd() {
        Date date = new Date();
        return DateUtils.getDayEndTime(date);
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayBegin());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(DateUtils.getDayEnd());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek += 7;
        }
        cal.add(5, 2 - dayOfWeek);
        return DateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return DateUtils.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, 1);
        return DateUtils.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(DateUtils.getNowYear(), DateUtils.getNowMonth() - 1, day);
        return DateUtils.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtils.getNowYear());
        cal.set(2, 0);
        cal.set(5, 1);
        return DateUtils.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, DateUtils.getNowYear());
        cal.set(2, 11);
        cal.set(5, 31);
        return DateUtils.getDayEndTime(cal.getTime());
    }

    public static Date getDayStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (null != date) {
            calendar.setTime(date);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getDayEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (null != date) {
            calendar.setTime(date);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Date getStartMonthDate(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getTime();
    }

    public static Date getEndMonthDate(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(year, month - 1, day);
        return calendar.getTime();
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getWhichMonth(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        return (int)diff;
    }

    public static long dateDiff(Date beginDate, Date endDate) {
        long date1ms = beginDate.getTime();
        long date2ms = endDate.getTime();
        return date2ms - date1ms;
    }

    public static Date max(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return beginDate;
        }
        return endDate;
    }

    public static Date min(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return endDate;
        }
        return beginDate;
    }

    public static Date getFirstSeasonDate(Date date) {
        int[] season = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = season[cal.get(2)];
        cal.set(2, sean * 3 - 3);
        return cal.getTime();
    }

    public static Date getNextHour(Date date, int t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(11, t);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(5, t);
        return cal.getTime();
    }

    public static Date getNextMonth(Date date, int t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, t);
        return cal.getTime();
    }

    public static Date getFrontMonth(Date date, int t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(2, -t);
        return cal.getTime();
    }

    public static Date getNextYear(Date date, int t) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        ((Calendar)cal).add(1, t);
        return cal.getTime();
    }

    public static List<List<Date>> getTimeList(int beginYear, int beginMonth, int endYear, int endMonth, int t) {
        ArrayList<List<Date>> list = new ArrayList<List<Date>>();
        if (beginYear == endYear) {
            for (int j = beginMonth; j <= endMonth; ++j) {
                list.add(DateUtils.getTimeList(beginYear, j, t));
            }
        } else {
            int j;
            int monthNum = 12;
            for (j = beginMonth; j < monthNum; ++j) {
                list.add(DateUtils.getTimeList(beginYear, j, t));
            }
            for (int i = beginYear + 1; i < endYear; ++i) {
                for (int j2 = 0; j2 < monthNum; ++j2) {
                    list.add(DateUtils.getTimeList(i, j2, t));
                }
            }
            for (j = 0; j <= endMonth; ++j) {
                list.add(DateUtils.getTimeList(endYear, j, t));
            }
        }
        return list;
    }

    public static List<Date> getTimeList(int beginYear, int beginMonth, int t) {
        ArrayList<Date> list = new ArrayList<Date>();
        GregorianCalendar beginCal = new GregorianCalendar(beginYear, beginMonth, 1);
        int max = ((Calendar)beginCal).getActualMaximum(5);
        for (int i = 1; i < max; i += t) {
            list.add(beginCal.getTime());
            ((Calendar)beginCal).add(5, t);
        }
        beginCal = new GregorianCalendar(beginYear, beginMonth, max);
        list.add(beginCal.getTime());
        return list;
    }

    public static int getWhichDay(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(5);
    }

    public static int getWhichWeek(Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        int dayForWeek = gc.get(7) == 1 ? 7 : gc.get(7) - 1;
        return dayForWeek;
    }

    public static String format(Date date, String pattern) {
        SimpleDateFormat sd = new SimpleDateFormat(pattern);
        return sd.format(date);
    }

    public static Date parse(String date, String pattern) throws ParseException {
        SimpleDateFormat sd = new SimpleDateFormat(pattern);
        return sd.parse(date);
    }

    public static String getCurrentTimeStamp(String pattern) {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        return DateUtils.format(ts, pattern);
    }

    public static String date2TimeStamp(Date date) {
        return String.valueOf(date.getTime() / 1000L);
    }

    public static List<Map<String, String>> sliceUpDateRange(String startDate, String endDate) {
        ArrayList<Map<String, String>> rs = new ArrayList<Map<String, String>>();
        try {
            int dt = 5;
            String pattern = "yyyy-MM-dd";
            if (startDate.matches(YEAR_REGEX)) {
                pattern = "yyyy";
                dt = 1;
            } else if (startDate.matches(MONTH_REGEX)) {
                pattern = "yyyy-MM";
                dt = 2;
            } else if (startDate.matches(DATE_REGEX)) {
                pattern = "yyyy-MM-dd";
                dt = 5;
            }
            Calendar sc = Calendar.getInstance();
            Calendar ec = Calendar.getInstance();
            sc.setTime(DateUtils.parse(startDate, pattern));
            ec.setTime(DateUtils.parse(endDate, pattern));
            while (sc.compareTo(ec) < 1) {
                HashMap<String, String> map = new HashMap<String, String>(2);
                map.put("date", DateUtils.format(sc.getTime(), pattern));
                sc.add(dt, 1);
                map.put("nextDate", DateUtils.format(sc.getTime(), pattern));
                rs.add(map);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    private DateUtils() {
    }
}

