/*
 * Decompiled with CFR 0.152.
 */
package com.lmaye.app.common.utils;

import java.util.List;
import java.util.regex.Pattern;

public final class RequestUriUtils {
    public static String getRegPath(String path) {
        char[] chars = path.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder();
        boolean preX = false;
        for (int i = 0; i < len; ++i) {
            if (chars[i] == '*') {
                if (preX) {
                    sb.append(".*");
                    preX = false;
                    continue;
                }
                if (i + 1 == len) {
                    sb.append("[^/]*");
                    continue;
                }
                preX = true;
                continue;
            }
            if (preX) {
                sb.append("[^/]*");
                preX = false;
            }
            if (chars[i] == '?') {
                sb.append('.');
                continue;
            }
            sb.append(chars[i]);
        }
        return sb.toString();
    }

    public static boolean filterUrls(String whiteUri, String reqUrl) {
        return Pattern.compile(RequestUriUtils.getRegPath(whiteUri)).matcher(reqUrl).matches();
    }

    public static boolean checkWhites(List<String> whiteUris, String reqUri) {
        return whiteUris.stream().anyMatch(url -> RequestUriUtils.filterUrls(url, reqUri));
    }
}

