/*
 * Decompiled with CFR 0.152.
 */
package com.localebro.okhttpprofiler;

import com.localebro.okhttpprofiler.transfer.DataTransfer;
import com.localebro.okhttpprofiler.transfer.LogDataTransfer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.Interceptor;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class OkHttpProfilerInterceptor
implements Interceptor {
    private final DataTransfer dataTransfer = new LogDataTransfer();
    private final DateFormat format = new SimpleDateFormat("ddhhmmssSSS", Locale.US);
    private final AtomicLong previousTime = new AtomicLong();

    @NotNull
    public Response intercept(Interceptor.Chain chain) throws IOException {
        String id = this.generateId();
        long startTime = System.currentTimeMillis();
        this.dataTransfer.sendRequest(id, chain.request());
        try {
            Response response = chain.proceed(chain.request());
            this.dataTransfer.sendResponse(id, response);
            this.dataTransfer.sendDuration(id, System.currentTimeMillis() - startTime);
            return response;
        }
        catch (Exception e) {
            this.dataTransfer.sendException(id, e);
            this.dataTransfer.sendDuration(id, System.currentTimeMillis() - startTime);
            throw e;
        }
    }

    private synchronized String generateId() {
        long previousTime;
        long currentTime = Long.parseLong(this.format.format(new Date()));
        if (currentTime <= (previousTime = this.previousTime.get())) {
            currentTime = ++previousTime;
        }
        this.previousTime.set(currentTime);
        return Long.toString(currentTime, 36);
    }
}

