/*
 * Decompiled with CFR 0.152.
 */
package com.localebro.okhttpprofiler.transfer;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.localebro.okhttpprofiler.transfer.DataTransfer;
import com.localebro.okhttpprofiler.transfer.MessageType;
import java.io.IOException;
import java.nio.charset.Charset;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;

public class LogDataTransfer
implements DataTransfer {
    private static final int LOG_LENGTH = 4000;
    private static final int SLOW_DOWN_PARTS_AFTER = 20;
    private static final int BODY_BUFFER_SIZE = 0xA00000;
    private static final String LOG_PREFIX = "OKPRFL";
    private static final String DELIMITER = "_";
    private static final Character HEADER_DELIMITER = Character.valueOf(':');
    private static final Character SPACE = Character.valueOf(' ');
    private static final String KEY_TAG = "TAG";
    private static final String KEY_VALUE = "VALUE";
    private static final String KEY_PARTS_COUNT = "PARTS_COUNT";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONTENT_LENGTH = "Content-Length";
    private final Handler mHandler;

    public LogDataTransfer() {
        HandlerThread handlerThread = new HandlerThread("OkHttpProfiler", 10);
        handlerThread.start();
        this.mHandler = new LogBodyHandler(handlerThread.getLooper());
    }

    @Override
    public void sendRequest(String id, Request request) throws IOException {
        this.fastLog(id, MessageType.REQUEST_METHOD, request.method());
        String url = request.url().toString();
        this.fastLog(id, MessageType.REQUEST_URL, url);
        this.fastLog(id, MessageType.REQUEST_TIME, String.valueOf(System.currentTimeMillis()));
        Request copy = request.newBuilder().build();
        Buffer buffer = new Buffer();
        RequestBody body = copy.body();
        if (body != null) {
            long contentLength;
            MediaType type = body.contentType();
            if (type != null) {
                this.fastLog(id, MessageType.REQUEST_HEADER, CONTENT_TYPE + HEADER_DELIMITER + SPACE + type.toString());
            }
            if ((contentLength = body.contentLength()) != -1L) {
                this.fastLog(id, MessageType.REQUEST_HEADER, CONTENT_LENGTH + HEADER_DELIMITER + SPACE + contentLength);
            }
        }
        Headers headers = request.headers();
        for (String name : headers.names()) {
            if (CONTENT_TYPE.equalsIgnoreCase(name) || CONTENT_LENGTH.equalsIgnoreCase(name)) continue;
            this.fastLog(id, MessageType.REQUEST_HEADER, name + HEADER_DELIMITER + SPACE + headers.get(name));
        }
        if (body != null) {
            body.writeTo((BufferedSink)buffer);
            this.largeLog(id, MessageType.REQUEST_BODY, buffer.readString(Charset.defaultCharset()));
        }
    }

    @Override
    public void sendResponse(String id, Response response) throws IOException {
        ResponseBody responseBodyCopy = response.peekBody(0xA00000L);
        this.largeLog(id, MessageType.RESPONSE_BODY, responseBodyCopy.string());
        Headers headers = response.headers();
        this.logWithHandler(id, MessageType.RESPONSE_STATUS, String.valueOf(response.code()), 0);
        for (String name : headers.names()) {
            this.logWithHandler(id, MessageType.RESPONSE_HEADER, name + HEADER_DELIMITER + headers.get(name), 0);
        }
    }

    @Override
    public void sendException(String id, Exception response) {
        this.logWithHandler(id, MessageType.RESPONSE_ERROR, response.getLocalizedMessage(), 0);
    }

    @Override
    public void sendDuration(String id, long duration) {
        this.logWithHandler(id, MessageType.RESPONSE_TIME, String.valueOf(duration), 0);
        this.logWithHandler(id, MessageType.RESPONSE_END, "-->", 0);
    }

    @SuppressLint(value={"LogNotTimber"})
    private void fastLog(String id, MessageType type, String message) {
        String tag = "OKPRFL_" + id + DELIMITER + type.name;
        if (message != null) {
            Log.v((String)tag, (String)message);
        }
    }

    private void logWithHandler(String id, MessageType type, String message, int partsCount) {
        Message handlerMessage = this.mHandler.obtainMessage();
        String tag = "OKPRFL_" + id + DELIMITER + type.name;
        Bundle bundle = new Bundle();
        bundle.putString(KEY_TAG, tag);
        bundle.putString(KEY_VALUE, message);
        bundle.putInt(KEY_PARTS_COUNT, partsCount);
        handlerMessage.setData(bundle);
        this.mHandler.sendMessage(handlerMessage);
    }

    private void largeLog(String id, MessageType type, String content) {
        int contentLength = content.length();
        if (content.length() > 4000) {
            int parts = contentLength / 4000;
            for (int i = 0; i <= parts; ++i) {
                int start = i * 4000;
                int end = start + 4000;
                if (end > contentLength) {
                    end = contentLength;
                }
                this.logWithHandler(id, type, content.substring(start, end), parts);
            }
        } else {
            this.logWithHandler(id, type, content, 0);
        }
    }

    private static class LogBodyHandler
    extends Handler {
        private LogBodyHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            Bundle bundle = msg.getData();
            if (bundle != null) {
                int partsCount = bundle.getInt(LogDataTransfer.KEY_PARTS_COUNT, 0);
                if (partsCount > 20) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                String data = bundle.getString(LogDataTransfer.KEY_VALUE);
                String key = bundle.getString(LogDataTransfer.KEY_TAG);
                if (data != null && key != null) {
                    Log.v((String)key, (String)data);
                }
            }
        }
    }
}

