/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.net;

import com.logentries.net.LogTooLongException;
import com.logentries.net.LogentriesClient;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;

public class AsyncLogger {
    private static final int QUEUE_SIZE = 32768;
    public static final int LOG_LENGTH_LIMIT = 65536;
    private static final int RECURSION_LIMIT = 32;
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final int MIN_DELAY = 100;
    private static final int MAX_DELAY = 10000;
    private static final String LE = "LE ";
    private static final String LINE_SEP = System.getProperty("line_separator", "\n");
    private static final String INVALID_TOKEN = "\n\nIt appears your LOGENTRIES_TOKEN parameter in log4j.xml is incorrect!\n\n";
    private static final String CONFIG_TOKEN = "LOGENTRIES_TOKEN";
    private static final String QUEUE_OVERFLOW = "\n\nLogentries Buffer Queue Overflow. Message Dropped!\n\n";
    private static final String LIBRARY_ID = "###J01### - Library initialised";
    String token = "";
    String key = "";
    String location = "";
    boolean httpPut = false;
    boolean ssl = false;
    boolean debug = false;
    boolean local = false;
    boolean started = false;
    SocketAppender appender;
    ArrayBlockingQueue<String> queue;

    public void setToken(String token) {
        this.token = token;
        this.dbg("Setting token to " + token);
    }

    public String getToken() {
        return this.token;
    }

    public void setHttpPut(boolean HttpPut) {
        this.httpPut = HttpPut;
    }

    public boolean getHttpPut() {
        return this.httpPut;
    }

    public void setKey(String account_key) {
        this.key = account_key;
    }

    public String getKey() {
        return this.key;
    }

    public void setLocation(String log_location) {
        this.location = log_location;
    }

    public String getLocation() {
        return this.location;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean getSsl() {
        return this.ssl;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        this.dbg("Setting debug to " + debug);
    }

    public boolean getDebug() {
        return this.debug;
    }

    AsyncLogger(boolean local) {
        this.local = local;
        this.queue = new ArrayBlockingQueue(32768);
        this.queue.offer(LIBRARY_ID);
        this.appender = new SocketAppender();
    }

    public AsyncLogger() {
        this(false);
    }

    boolean checkValidUUID(String uuid) {
        if ("".equals(uuid)) {
            return false;
        }
        try {
            UUID u = UUID.fromString(uuid);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    String getEnvVar(String key) {
        String envVal = System.getenv(key);
        return envVal != null ? envVal : "";
    }

    boolean checkCredentials() {
        if (!this.httpPut) {
            if (this.token.equals(CONFIG_TOKEN) || this.token.equals("")) {
                String envToken = this.getEnvVar(CONFIG_TOKEN);
                if (envToken == "") {
                    this.dbg(INVALID_TOKEN);
                    return false;
                }
                this.setToken(envToken);
            }
            return this.checkValidUUID(this.getToken());
        }
        return this.checkValidUUID(this.getKey()) && !this.getLocation().equals("");
    }

    public void addLineToQueue(String line) {
        this.addLineToQueue(line, 32);
    }

    private void addLineToQueue(String line, int limit) {
        if (limit == 0) {
            throw new LogTooLongException();
        }
        if (!this.started && this.checkCredentials()) {
            this.dbg("Starting Logentries asynchronous socket appender");
            this.appender.start();
            this.started = true;
        }
        this.dbg("Queueing " + line);
        if (line.length() > 65536) {
            if (!this.queue.offer(line.substring(0, 65536))) {
                this.queue.poll();
                if (!this.queue.offer(line.substring(0, 65536))) {
                    this.dbg(QUEUE_OVERFLOW);
                }
            }
            this.addLineToQueue(line.substring(65536, line.length()), limit - 1);
        } else if (!this.queue.offer(line)) {
            this.queue.poll();
            if (!this.queue.offer(line)) {
                this.dbg(QUEUE_OVERFLOW);
            }
        }
    }

    public void close() {
        this.appender.interrupt();
        this.started = false;
        this.dbg("Closing Logentries asynchronous socket appender");
    }

    void dbg(String msg) {
        if (this.debug) {
            if (!msg.endsWith(LINE_SEP)) {
                System.err.println(LE + msg);
            } else {
                System.err.print(LE + msg);
            }
        }
    }

    static /* synthetic */ String access$100() {
        return LINE_SEP;
    }

    static /* synthetic */ Charset access$200() {
        return UTF8;
    }

    class SocketAppender
    extends Thread {
        final Random random;
        LogentriesClient le_client;

        SocketAppender() {
            super("Logentries Socket appender");
            this.random = new Random();
            this.setDaemon(true);
        }

        void openConnection() throws IOException {
            try {
                if (this.le_client == null) {
                    this.le_client = new LogentriesClient(AsyncLogger.this.httpPut, AsyncLogger.this.ssl);
                }
                this.le_client.connect();
                if (AsyncLogger.this.httpPut) {
                    String f = "PUT /%s/hosts/%s/?realtime=1 HTTP/1.1\r\n\r\n";
                    String header = String.format("PUT /%s/hosts/%s/?realtime=1 HTTP/1.1\r\n\r\n", AsyncLogger.this.key, AsyncLogger.this.location);
                    byte[] temp = header.getBytes(ASCII);
                    this.le_client.write(temp, 0, temp.length);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void reopenConnection() throws InterruptedException {
            this.closeConnection();
            int root_delay = 100;
            while (true) {
                try {
                    this.openConnection();
                    return;
                }
                catch (IOException e) {
                    if (AsyncLogger.this.debug) {
                        AsyncLogger.this.dbg("Unable to connect to Logentries");
                        e.printStackTrace();
                    }
                    if ((root_delay *= 2) > 10000) {
                        root_delay = 10000;
                    }
                    int wait_for = root_delay + this.random.nextInt(root_delay);
                    AsyncLogger.this.dbg("Waiting for " + wait_for + "ms");
                    Thread.sleep(wait_for);
                    continue;
                }
                break;
            }
        }

        void closeConnection() {
            if (this.le_client != null) {
                this.le_client.close();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                this.reopenConnection();
                block4: while (true) lbl-1000:
                // 2 sources

                {
                    data = AsyncLogger.this.queue.take();
                    data = data.replace(AsyncLogger.access$100(), "\u2028");
                    final_data = (AsyncLogger.this.httpPut == false ? AsyncLogger.this.token + data : data) + '\n';
                    finalLine = final_data.getBytes(AsyncLogger.access$200());
                    while (true) {
                        try {
                            this.le_client.write(finalLine, 0, finalLine.length);
                            continue block4;
                        }
                        catch (IOException e) {
                            this.reopenConnection();
                            continue;
                        }
                        break;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                AsyncLogger.this.dbg("Asynchronous socket writer interrupted");
                AsyncLogger.this.dbg("Queue had " + AsyncLogger.this.queue.size() + " lines left in it");
                this.closeConnection();
                return;
            }
            {
                ** while (true)
            }
        }
    }
}

