/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class LogentriesClient {
    private static final String LE_TOKEN_API = "data.logentries.com";
    private static final String LE_HTTP_API = "api.logentries.com";
    private static final int LE_PORT = 80;
    private static final int LE_SSL_PORT = 443;
    final SSLSocketFactory ssl_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    private boolean ssl_choice = false;
    private boolean http_choice = false;
    private Socket socket;
    private OutputStream stream;

    public LogentriesClient(boolean httpPut, boolean ssl) {
        this.ssl_choice = ssl;
        this.http_choice = httpPut;
    }

    public int getPort() {
        return this.ssl_choice ? 443 : 80;
    }

    public String getAddress() {
        return this.http_choice ? LE_HTTP_API : LE_TOKEN_API;
    }

    public void connect() throws UnknownHostException, IOException {
        if (this.ssl_choice) {
            if (this.http_choice) {
                SSLSocket s = (SSLSocket)this.ssl_factory.createSocket(this.getAddress(), this.getPort());
                s.setTcpNoDelay(true);
                s.startHandshake();
                this.socket = s;
            } else {
                this.socket = SSLSocketFactory.getDefault().createSocket(this.getAddress(), this.getPort());
            }
        } else {
            this.socket = new Socket(this.getAddress(), this.getPort());
        }
        this.stream = this.socket.getOutputStream();
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.stream == null) {
            throw new IOException();
        }
        this.stream.write(buffer, offset, length);
        this.stream.flush();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

