/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.jul;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public final class LogentriesHandler
extends Handler {
    private String host;
    private int port;
    private byte[] token;
    private boolean open;
    private SocketChannel channel;
    private ByteBuffer buffer;
    private final byte[] newline = new byte[]{13, 10};
    private final byte space = (byte)32;

    public LogentriesHandler() {
        this.configure();
        this.connect();
        this.buffer = ByteBuffer.allocate(4096);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public byte[] getToken() {
        return this.token;
    }

    public void setToken(byte[] token) {
        this.token = token;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        boolean drained;
        boolean filled;
        String msg;
        if (this.open && this.isLoggable(record) && !(msg = this.formatMessage(record)).isEmpty() && (filled = this.fillAndFlip(msg)) && !(drained = this.drain())) {
            System.err.println("java.util.logging.ErrorManager: Sending to logentries.com failed. Trying to reconnect once.");
            this.connect();
            if (this.open && (filled = this.fillAndFlip(msg)) && !(drained = this.drain())) {
                System.err.println("java.util.logging.ErrorManager: Unable to reconnect. Shutting handler down.");
                this.close();
            }
        }
    }

    String formatMessage(LogRecord record) {
        String msg = "";
        try {
            msg = this.getFormatter().format(record);
            msg = msg.replace(System.getProperty("line.separator"), "\u2028");
        }
        catch (Exception e) {
            this.reportError("Error while formatting.", e, 5);
        }
        return msg;
    }

    boolean fillAndFlip(String formattedMessage) {
        try {
            this.buffer.clear();
            this.buffer.put(this.token);
            this.buffer.put((byte)32);
            this.buffer.put(formattedMessage.getBytes(Charset.forName("UTF-8")));
            this.buffer.put(this.newline);
        }
        catch (BufferOverflowException e) {
            this.reportError("Buffer exceeds capacity", e, 1);
            return false;
        }
        this.buffer.flip();
        return true;
    }

    boolean drain() {
        while (this.buffer.hasRemaining()) {
            try {
                this.channel.write(this.buffer);
            }
            catch (Exception e) {
                this.reportError("Error while writing channel.", e, 1);
                return false;
            }
        }
        return true;
    }

    void configure() {
        String cname = this.getClass().getName();
        this.setLevel(this.getLevelProperty(cname + ".level", Level.INFO));
        this.setFormatter(this.getFormatterProperty(cname + ".formatter", new SimpleFormatter()));
        this.setHost(this.getStringProperty(cname + ".host", "data.logentries.com"));
        this.setPort(this.getIntProperty(cname + ".port", 514));
        this.setToken(this.getBytesProperty(cname + ".token", ""));
    }

    void connect() {
        try {
            this.channel = SocketChannel.open();
            this.channel.connect(new InetSocketAddress(this.host, this.port));
            this.open = true;
        }
        catch (IOException e) {
            this.open = false;
            this.reportError(MessageFormat.format("Error connection to host: {0}:{1}", this.host, this.port), e, 4);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.open = false;
        this.buffer = null;
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException e) {
                this.reportError("Error while closing channel.", e, 3);
            }
        }
    }

    Level getLevelProperty(String name, Level defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        Level l = Level.parse(val.trim());
        return l != null ? l : defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        try {
            if (val != null) {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> clz = cl.loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
        }
        catch (InstantiationException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
        }
        catch (IllegalAccessException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
        }
        return defaultValue;
    }

    String getStringProperty(String name, String defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    byte[] getBytesProperty(String name, String defaultValue) {
        return this.getStringProperty(name, defaultValue).getBytes();
    }

    int getIntProperty(String name, int defaultValue) {
        LogManager manager = LogManager.getLogManager();
        String val = manager.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (NumberFormatException e) {
            this.reportError(MessageFormat.format("Error reading property ''{0}''", name), e, 0);
            return defaultValue;
        }
    }
}

