/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import com.logentries.logback.ExceptionFormatter;
import com.logentries.net.AsyncLogger;

public class LogentriesAppender
extends AppenderBase<ILoggingEvent> {
    private final AsyncLogger le_async;
    private Layout<ILoggingEvent> layout;
    private String facilityStr;
    public static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %logger %msg";
    private String suffixPattern;

    public LogentriesAppender() {
        this.le_async = new AsyncLogger();
    }

    public LogentriesAppender(AsyncLogger logger) {
        this.le_async = logger;
    }

    public void setToken(String token) {
        this.le_async.setToken(token);
    }

    public void setHttpPut(boolean HttpPut) {
        this.le_async.setHttpPut(HttpPut);
    }

    public void setKey(String account_key) {
        this.le_async.setKey(account_key);
    }

    public void setLocation(String log_location) {
        this.le_async.setLocation(log_location);
    }

    public void setSsl(boolean ssl) {
        this.le_async.setSsl(ssl);
    }

    public void setDebug(boolean debug) {
        this.le_async.setDebug(debug);
    }

    public void setIsUsingDataHub(boolean useDataHub) {
        this.le_async.setUseDataHub(useDataHub);
    }

    public void setDataHubAddr(String dataHubAddr) {
        this.le_async.setDataHubAddr(dataHubAddr);
    }

    public void setDataHubPort(int dataHubPort) {
        this.le_async.setDataHubPort(dataHubPort);
    }

    public void setLogHostName(boolean logHostName) {
        this.le_async.setLogHostName(logHostName);
    }

    public void setHostName(String hostName) {
        this.le_async.setHostName(hostName);
    }

    public void setLogID(String logID) {
        this.le_async.setLogID(logID);
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.suffixPattern = encoder.getPattern();
    }

    public void start() {
        if (this.layout == null) {
            this.layout = this.buildLayout();
        }
        super.start();
    }

    String getPrefixPattern() {
        return "%syslogStart{" + this.getFacility() + "}%nopex";
    }

    public String getFacility() {
        return this.facilityStr;
    }

    public void setFacility(String facilityStr) {
        if (facilityStr != null) {
            facilityStr = facilityStr.trim();
        }
        this.facilityStr = facilityStr;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }

    protected void append(ILoggingEvent event) {
        String formattedEvent = this.layout.doLayout((Object)event);
        IThrowableProxy error = event.getThrowableProxy();
        if (error != null) {
            formattedEvent = formattedEvent + ExceptionFormatter.formatException(error);
        }
        this.le_async.addLineToQueue(formattedEvent);
    }

    public void stop() {
        super.stop();
        this.le_async.close();
    }

    public Layout<ILoggingEvent> buildLayout() {
        PatternLayout l = new PatternLayout();
        l.getInstanceConverterMap().put("syslogStart", SyslogStartConverter.class.getName());
        if (this.suffixPattern == null) {
            this.suffixPattern = DEFAULT_SUFFIX_PATTERN;
        }
        l.setPattern(this.getPrefixPattern() + this.suffixPattern);
        l.setContext(this.getContext());
        l.start();
        return l;
    }

    public String getSuffixPattern() {
        return this.suffixPattern;
    }

    public void setSuffixPattern(String suffixPattern) {
        this.suffixPattern = suffixPattern;
    }
}

