/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.log4j2;

import com.logentries.log4j2.FactoryData;
import com.logentries.net.AsyncLogger;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.async.AsyncLoggerContext;

public class LogentriesManager
extends AbstractManager {
    private static LogentriesManagerFactory FACTORY = new LogentriesManagerFactory();
    private final AsyncLogger asyncLogger = new AsyncLogger();

    static LogentriesManager getManager(String name, FactoryData data) {
        return (LogentriesManager)LogentriesManager.getManager((String)name, (ManagerFactory)FACTORY, (Object)data);
    }

    protected LogentriesManager(LoggerContext loggerContext, String name, FactoryData data) {
        super(loggerContext, name);
        this.asyncLogger.setToken(data.getToken());
        this.asyncLogger.setKey(data.getKey());
        this.asyncLogger.setLocation(this.nullToEmpty(data.getLocation()));
        this.asyncLogger.setHttpPut(data.isHttpPut());
        this.asyncLogger.setSsl(data.isSsl());
        this.asyncLogger.setDebug(data.isDebug());
        this.asyncLogger.setUseDataHub(data.isUseDataHub());
        this.asyncLogger.setDataHubAddr(data.getDataHubAddr());
        this.asyncLogger.setDataHubPort(data.getDataHubPort());
        this.asyncLogger.setLogHostName(data.isLogHostName());
        this.asyncLogger.setHostName(this.nullToEmpty(data.getHostName()));
        this.asyncLogger.setLogID(this.nullToEmpty(data.getLogID()));
        LOGGER.debug("AsyncLogger created.");
    }

    private String nullToEmpty(String s) {
        return s == null ? "" : s;
    }

    protected boolean releaseSub(long timeout, TimeUnit timeUnit) {
        this.asyncLogger.close();
        LOGGER.debug("AsyncLogger closed.");
        return super.releaseSub(timeout, timeUnit);
    }

    public void writeLine(String line) {
        this.asyncLogger.addLineToQueue(line);
    }

    static class LogentriesManagerFactory
    implements ManagerFactory<LogentriesManager, FactoryData> {
        LogentriesManagerFactory() {
        }

        public LogentriesManager createManager(String name, FactoryData data) {
            return new LogentriesManager((LoggerContext)new AsyncLoggerContext(name), name, data);
        }
    }
}

