/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.logback;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;

public class ExceptionFormatter {
    public static final String DELIMITER = "\u2028";
    public static final String TAB = "\t";

    public static String formatException(IThrowableProxy error) {
        String ex = "";
        ex = ex + ExceptionFormatter.formatTopLevelError(error);
        ex = ex + ExceptionFormatter.formatStackTraceElements(error.getStackTraceElementProxyArray());
        ex = ex + DELIMITER;
        for (IThrowableProxy cause = error.getCause(); cause != null; cause = cause.getCause()) {
            ex = ex + ExceptionFormatter.formatTopLevelError(cause);
            StackTraceElementProxy[] arr = cause.getStackTraceElementProxyArray();
            ex = ex + ExceptionFormatter.formatStackTraceElements(arr);
            ex = ex + DELIMITER;
        }
        return ex;
    }

    private static String formatStackTraceElements(StackTraceElementProxy[] elements) {
        String s = "";
        if (elements != null) {
            for (StackTraceElementProxy e : elements) {
                s = s + "\u2028\t" + e.getSTEAsString();
            }
        }
        return s;
    }

    private static String formatTopLevelError(IThrowableProxy error) {
        return error.getClassName() + ": " + error.getMessage();
    }
}

