/*
 * Decompiled with CFR 0.152.
 */
package com.logentries.net;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class LogentriesClient {
    private static final String LE_TOKEN_API = "data.logentries.com";
    private static final String LE_HTTP_API = "api.logentries.com";
    private static final int LE_PORT = 80;
    private static final int LE_SSL_PORT = 443;
    private final SSLSocketFactory ssl_factory;
    private boolean ssl_choice = false;
    private boolean http_choice = false;
    private Socket socket;
    private OutputStream outputStream;
    private String dataHubServer = "data.logentries.com";
    private int dataHubPort = 80;
    private boolean useDataHub = false;

    public LogentriesClient(boolean httpPut, boolean ssl, boolean isUsingDataHub, String server, int port) {
        if (isUsingDataHub) {
            this.ssl_factory = null;
            this.ssl_choice = false;
            this.useDataHub = true;
            this.dataHubServer = server;
            this.dataHubPort = port;
        } else {
            this.ssl_factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            this.ssl_choice = ssl;
            this.http_choice = httpPut;
        }
    }

    public int getPort() {
        if (this.useDataHub) {
            return this.dataHubPort;
        }
        return this.ssl_choice ? 443 : 80;
    }

    public String getAddress() {
        if (this.useDataHub) {
            return this.dataHubServer;
        }
        return this.http_choice ? LE_HTTP_API : LE_TOKEN_API;
    }

    public void connect() throws IOException {
        if (this.ssl_choice) {
            if (this.http_choice) {
                SSLSocket s = (SSLSocket)this.ssl_factory.createSocket(this.getAddress(), this.getPort());
                s.startHandshake();
                this.socket = s;
            } else {
                this.socket = this.ssl_factory.createSocket(this.getAddress(), this.getPort());
            }
        } else {
            this.socket = new Socket(this.getAddress(), this.getPort());
        }
        this.socket.setKeepAlive(true);
        this.outputStream = this.socket.getOutputStream();
    }

    public void write(byte[] buffer, int offset, int length) throws IOException {
        if (this.outputStream == null) {
            throw new IOException();
        }
        this.outputStream.write(buffer, offset, length);
        this.outputStream.flush();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

