/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core;

import com.logicartisan.common.core.thread.ThreadKit;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import javax.annotation.Nullable;

public class IOKit {
    public static final ThreadLocal<Boolean> DESERIALIZATION_HINT = new ThreadLocal();
    private static final boolean XSTREAM_SUPPORTED;

    public static boolean close(@Nullable Closeable closeable) {
        if (closeable == null) {
            return true;
        }
        try {
            closeable.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean close(ObjectInput input) {
        if (input == null) {
            return true;
        }
        try {
            input.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static boolean close(ObjectOutput output) {
        if (output == null) {
            return true;
        }
        try {
            output.close();
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] serialize(Object obj) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream b_out = null;
        ObjectOutputStream o_out = null;
        try {
            b_out = new ByteArrayOutputStream();
            o_out = new ObjectOutputStream(b_out);
            o_out.writeObject(obj);
            byArray = b_out.toByteArray();
        }
        catch (Throwable throwable) {
            IOKit.close(o_out);
            IOKit.close(b_out);
            throw throwable;
        }
        IOKit.close(o_out);
        IOKit.close(b_out);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        Boolean previous_value = DESERIALIZATION_HINT.get();
        DESERIALIZATION_HINT.set(Boolean.TRUE);
        try {
            Object object;
            ByteArrayInputStream b_in = null;
            ObjectInputStream o_in = null;
            try {
                b_in = new ByteArrayInputStream(data);
                o_in = new ObjectInputStream(b_in);
                object = o_in.readObject();
            }
            catch (Throwable throwable) {
                IOKit.close(o_in);
                IOKit.close(b_in);
                throw throwable;
            }
            IOKit.close(o_in);
            IOKit.close(b_in);
            return object;
        }
        finally {
            if (previous_value == null) {
                DESERIALIZATION_HINT.remove();
            } else {
                DESERIALIZATION_HINT.set(previous_value);
            }
        }
    }

    public static boolean isBeingDeserialized() {
        Boolean hint = DESERIALIZATION_HINT.get();
        if (hint != null) {
            return hint;
        }
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement element = stack[i];
            String method_name = element.getMethodName();
            String class_name = element.getClassName();
            if (class_name.equals("java.io.ObjectInputStream")) {
                return true;
            }
            if (XSTREAM_SUPPORTED && class_name.equals("com.thoughtworks.xstream.XStream") && method_name.equals("fromXML")) {
                return true;
            }
            if (i != 2 || !method_name.equals("readExternal")) continue;
            return true;
        }
        return false;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int read;
        byte[] buffer = new byte[10240];
        long total_written = 0L;
        while ((read = input.read(buffer)) >= 0) {
            if (read == 0) {
                ThreadKit.sleep(50L);
                continue;
            }
            output.write(buffer, 0, read);
            total_written += (long)read;
        }
        return total_written;
    }

    public static long copy(Reader input, Writer output) throws IOException {
        int read;
        char[] buffer = new char[10240];
        long total_written = 0L;
        while ((read = input.read(buffer)) >= 0) {
            if (read == 0) {
                ThreadKit.sleep(50L);
                continue;
            }
            output.write(buffer, 0, read);
            total_written += (long)read;
        }
        return total_written;
    }

    public static long copy(ReadableByteChannel input, WritableByteChannel output, ByteBuffer buffer) throws IOException {
        int read;
        if (buffer == null) {
            buffer = ByteBuffer.allocate(65536);
        } else {
            buffer.clear();
        }
        long total_written = 0L;
        while ((read = input.read(buffer)) != -1) {
            if (read != 0) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    output.write(buffer);
                }
                total_written += (long)read;
            }
            buffer.clear();
        }
        return total_written;
    }

    public static char[] readPasswordFromConsole(String prompt) throws IOException {
        Console console = System.console();
        if (console != null) {
            if (prompt != null) {
                System.out.print(MessageFormat.format(prompt, ""));
            }
            return console.readPassword();
        }
        if (prompt != null) {
            System.out.print(MessageFormat.format(prompt, " (warning: password will be visible)"));
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = in.readLine();
            if (line == null) {
                return null;
            }
            return line.toCharArray();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String readFromConsole(String prompt) throws IOException {
        Console console;
        if (prompt != null) {
            System.out.print(prompt);
        }
        if ((console = System.console()) != null) {
            return console.readLine();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line = in.readLine();
            if (line == null) {
                return null;
            }
            return line;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }

    public static void deleteRecursive(File file) throws IOException {
        File[] files;
        if (!Files.exists(file.toPath(), LinkOption.NOFOLLOW_LINKS)) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                IOKit.deleteRecursive(child);
            }
        }
        Files.delete(file.toPath());
    }

    static {
        boolean supported = false;
        try {
            Class.forName("com.thoughtworks.xstream.XStream");
            supported = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        XSTREAM_SUPPORTED = supported;
    }
}

