/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.listeners;

import com.logicartisan.common.core.listeners.MessageDeliveryErrorHandler;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCountDeliveryErrorHandler<T>
implements MessageDeliveryErrorHandler<T> {
    private static final boolean ERROR_DEBUG = System.getProperty("starlight.listeners.print_dispatch_errors") != null;
    private static final Logger LOG = LoggerFactory.getLogger(ErrorCountDeliveryErrorHandler.class);
    private final int max_error_count;
    private final boolean retry_message;

    public ErrorCountDeliveryErrorHandler(int max_error_count) {
        this(max_error_count, true);
    }

    public ErrorCountDeliveryErrorHandler(int max_error_count, boolean retry_message) {
        this.max_error_count = max_error_count;
        this.retry_message = retry_message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDeliveryErrorHandler.ErrorResponse deliveryError(T listener, Throwable throwable, int overall_error_count, int overall_success_count, int consecutive_errors, boolean fatal) {
        if (throwable instanceof AssertionError) {
            LOG.error("Listener delivery error (fatal:{} consecutive_errors:{} max_error_count:{}", new Object[]{fatal, consecutive_errors, this.max_error_count, throwable});
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Listener delivery error (fatal:{} consecutive_errors:{} max_error_count:{}", new Object[]{fatal, consecutive_errors, this.max_error_count, throwable});
        }
        if (ERROR_DEBUG) {
            PrintStream printStream = System.err;
            synchronized (printStream) {
                System.err.println("Listener delivery error (fatal: " + fatal + "  consecutive_errors: " + consecutive_errors + "  max_error_count: " + this.max_error_count + "  error: " + throwable);
                throwable.printStackTrace(System.err);
            }
        }
        if (fatal || consecutive_errors >= this.max_error_count) {
            LOG.info("Listener being removed due to dispatch errors: {}", listener, (Object)throwable);
            return MessageDeliveryErrorHandler.ErrorResponse.REMOVE_LISTENER;
        }
        if (this.retry_message) {
            return MessageDeliveryErrorHandler.ErrorResponse.RETRY_MESSAGE;
        }
        return MessageDeliveryErrorHandler.ErrorResponse.DROP_MESSAGE;
    }

    @Override
    public MessageDeliveryErrorHandler.ErrorResponse excessiveBacklog(T listener, int backlog_size, int consecutive_backlog_errors) {
        return MessageDeliveryErrorHandler.ErrorResponse.REMOVE_LISTENER;
    }

    @Override
    public void lastListenerRemoved() {
    }

    private boolean isOrCausedBy(Throwable t, Class<? extends Throwable> ex_class) {
        while (t != null) {
            if (ex_class.isAssignableFrom(t.getClass())) {
                return true;
            }
            t = t.getCause();
        }
        return false;
    }
}

