/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.listeners;

import com.logicartisan.common.core.listeners.ListenerFilter;
import com.logicartisan.common.core.listeners.MessageDeliveryErrorHandler;
import com.logicartisan.common.core.listeners.MessageInfo;
import com.logicartisan.common.core.thread.ThreadKit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListenerDispatchControl<T, A>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerDispatchControl.class);
    private final T listener;
    private final A attachment;
    private final AtomicReference<ListenerFilter<A>> filter_reference;
    private final MessageDeliveryErrorHandler<T> error_handler;
    private final RemoveSupport<T> remove_support;
    private final AtomicBoolean thread_processing_queue = new AtomicBoolean(false);
    private final Queue<MessageInfo> message_queue;
    private boolean need_special_access = false;
    private int overall_error_count = 0;
    private int overall_success_count = 0;
    private int consecutive_error_count = 0;
    private int consecutive_backlog_errors = 0;

    ListenerDispatchControl(T listener, int max_backlog_size, MessageDeliveryErrorHandler<T> error_handler, RemoveSupport<T> remove_support, A attachment, AtomicReference<ListenerFilter<A>> filter_reference) {
        this.listener = listener;
        this.error_handler = error_handler;
        this.remove_support = remove_support;
        this.attachment = attachment;
        this.filter_reference = filter_reference;
        this.message_queue = new LinkedBlockingQueue<MessageInfo>(max_backlog_size);
    }

    boolean postMessageInfoToQueue(Method method, Object ... args) {
        block9: {
            MessageDeliveryErrorHandler.ErrorResponse response;
            ListenerFilter<A> filter = this.filter_reference.get();
            if (filter != null && !filter.callMatchesFilter(this.attachment, method, args)) {
                return false;
            }
            block5: while (true) {
                boolean added;
                if (added = this.message_queue.offer(new MessageInfo(method, args))) break block9;
                ++this.consecutive_backlog_errors;
                response = this.error_handler.excessiveBacklog(this.listener, this.message_queue.size(), this.consecutive_backlog_errors);
                if (response == null) {
                    response = MessageDeliveryErrorHandler.ErrorResponse.REMOVE_LISTENER;
                }
                LOG.debug("message_queue for listener ({}) has exceeded its capacity. Response will be: {}", this.listener, (Object)response);
                switch (response) {
                    case REMOVE_LISTENER: {
                        this.handleListenerRemove();
                        return false;
                    }
                    case DROP_MESSAGE: {
                        return false;
                    }
                    case RETRY_MESSAGE: {
                        ThreadKit.sleep(10L);
                        continue block5;
                    }
                }
                break;
            }
            assert (false) : "Unknown response: " + (Object)((Object)response);
            return false;
        }
        this.consecutive_backlog_errors = 0;
        return this.thread_processing_queue.compareAndSet(false, true);
    }

    void indicateWorkerThreadStartFailure() {
        this.thread_processing_queue.set(false);
    }

    @Override
    public void run() {
        boolean run_loop = true;
        while (run_loop) {
            run_loop = false;
            try {
                this.inner_run();
            }
            finally {
                this.thread_processing_queue.set(false);
                if (this.message_queue.isEmpty() || !this.thread_processing_queue.compareAndSet(false, true)) continue;
                run_loop = true;
            }
        }
    }

    private void inner_run() {
        MessageInfo info = null;
        boolean retry_message = false;
        block12: while (retry_message || (info = this.message_queue.poll()) != null) {
            MessageDeliveryErrorHandler.ErrorResponse response;
            Throwable error;
            assert (!retry_message || info != null) : "Told to retry null message";
            retry_message = false;
            Method method = info.getMethod();
            Object[] args = info.getArgs();
            if (this.need_special_access) {
                method.setAccessible(true);
            }
            boolean error_is_fatal = false;
            try {
                method.invoke(this.listener, args);
                ++this.overall_success_count;
                this.consecutive_error_count = 0;
                continue;
            }
            catch (IllegalAccessException e) {
                if (this.need_special_access) {
                    error = e;
                    error_is_fatal = true;
                }
                this.need_special_access = true;
                retry_message = true;
                continue;
            }
            catch (InvocationTargetException ex) {
                error = ex.getTargetException();
            }
            catch (AssertionError er) {
                throw er;
            }
            catch (Throwable t) {
                error = t;
            }
            assert (error != null);
            ++this.overall_error_count;
            ++this.consecutive_error_count;
            try {
                response = this.error_handler.deliveryError(this.listener, error, this.overall_error_count, this.overall_success_count, this.consecutive_error_count, error_is_fatal);
            }
            catch (Throwable t) {
                LOG.warn("Exception thrown while dispatching error notification to MessageDeliveryErrorHandler. The message will be dropped.", t);
                response = MessageDeliveryErrorHandler.ErrorResponse.DROP_MESSAGE;
            }
            switch (response) {
                case DROP_MESSAGE: {
                    retry_message = false;
                    continue block12;
                }
                case RETRY_MESSAGE: {
                    retry_message = true;
                    ThreadKit.sleep(1000L);
                    continue block12;
                }
                case REMOVE_LISTENER: {
                    this.handleListenerRemove();
                    return;
                }
            }
            assert (false) : "Unknown response type";
        }
    }

    private void handleListenerRemove() {
        boolean was_last_listener = this.remove_support.removeListener(this.listener);
        this.message_queue.clear();
        if (was_last_listener) {
            this.error_handler.lastListenerRemoved();
        }
    }

    final A getAttachment() {
        return this.attachment;
    }

    public static interface RemoveSupport<T> {
        public boolean removeListener(T var1);
    }
}

