/*
 * Decompiled with CFR 0.152.
 */
package com.logicartisan.common.core.listeners;

import com.logicartisan.common.core.listeners.ErrorCountDeliveryErrorHandler;
import com.logicartisan.common.core.listeners.ListenerFilter;
import com.logicartisan.common.core.listeners.ListenerSupportImpl;
import com.logicartisan.common.core.listeners.MessageDeliveryErrorHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface ListenerSupport<T, A> {
    public void add(T var1);

    public void add(T var1, A var2);

    public boolean remove(T var1);

    public void removeAllListeners();

    public boolean hasListeners();

    public T dispatch();

    public A getAttachment(T var1);

    public void setListenerFilter(ListenerFilter<A> var1);

    public static <L, A> Builder<L, A> forType(Class<L> listener_class) {
        return new Builder(listener_class);
    }

    public static class Builder<L, A> {
        private final Class<L> listener_class;
        private Executor executor;
        private MessageDeliveryErrorHandler<L> error_handler;
        private int max_message_backlog = -1;
        private long delay = 0L;
        private TimeUnit delay_unit = TimeUnit.MILLISECONDS;

        Builder(Class<L> listener_class) {
            if (!listener_class.isInterface()) {
                throw new IllegalArgumentException("Class must be an interface");
            }
            try {
                this.delay = Long.getLong("com.starlight.listeners.default_message_delay", 0L);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.listener_class = listener_class;
        }

        public Builder<L, A> asynchronous() {
            return this.executor(ListenerSupportImpl.SHARED_NOTIFICATION_POOL);
        }

        public Builder<L, A> executor(Executor executor) {
            assert (executor != null) : "Executor has already been set: " + this.executor;
            this.executor = executor;
            return this;
        }

        public Builder<L, A> errorHandler(MessageDeliveryErrorHandler<L> handler) {
            this.error_handler = handler;
            return this;
        }

        public Builder<L, A> maxBacklog(int max_message_backlog) {
            this.max_message_backlog = max_message_backlog;
            return this;
        }

        public Builder<L, A> delay(long delay, TimeUnit unit) {
            this.delay = delay;
            this.delay_unit = unit;
            return this;
        }

        public ListenerSupport<L, A> build() {
            if (this.executor == null) {
                this.executor = Runnable::run;
            }
            if (this.error_handler == null) {
                this.error_handler = new ErrorCountDeliveryErrorHandler<L>(3);
            }
            if (this.max_message_backlog < 0) {
                try {
                    this.max_message_backlog = Integer.getInteger("com.starlight.listeners.default_max_message_backlog", 100);
                }
                catch (SecurityException ex) {
                    this.max_message_backlog = 100;
                }
            }
            return new ListenerSupportImpl(this.listener_class, this.executor, this.error_handler, this.max_message_backlog, this.delay, this.delay_unit);
        }
    }
}

